/************************************************************************
 * FILE:           clTmcTuner_Property_G_HD_AUDIOPRGM.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Property_G_HD_AUDIOPRGM.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
 
 *************************************************************************/


#include "AMFMTuner/clTmcTuner_Property_G_HD_AUDIOPRGM.h"
#include "CcaApp/clCCAhandler.h"
#include "kdsconfig/clConfigInterface.h"

#define ERROR_NOTAVAILABLE 0x000B

using namespace tuner::CcaApp;


/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Property_G_HD_AUDIOPRGM::~clTmcTuner_Property_G_HD_AUDIOPRGM()
{
	m_poclConfigInterface = 0;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Property_G_HD_AUDIOPRGM::clTmcTuner_Property_G_HD_AUDIOPRGM(clCCAhandler* poCCAhandler,clConfigInterface* poclConfigInterface)
   : clServerProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_HD_AUDIOPRGM, poCCAhandler)
	 ,m_poclConfigInterface(poclConfigInterface)
{
 
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_HD_AUDIOPRGM::vSet(amt_tclServiceData* /*poInMsg*/)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_HD_AUDIOPRGM::vGet(amt_tclServiceData* /*poInMsg*/)
{
	if ( m_poclConfigInterface!= NULL )
	{
		if(m_poclConfigInterface->u32GetConfigData("HDSupported"))
		{
			vSendStatus();
		}
		else
		{
			vError(MIDW_TUNERFI_C_U16_FID_TUN_G_HD_AUDIOPRGM,ERROR_NOTAVAILABLE);
		}
	}
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_HD_AUDIOPRGM::vUpreg(amt_tclServiceData* /*poInMsg*/)
{	
	if ( m_poclConfigInterface!= NULL )
	{
		if(!(m_poclConfigInterface->u32GetConfigData("HDSupported")))
		{
			vError(MIDW_TUNERFI_C_U16_FID_TUN_G_HD_AUDIOPRGM,ERROR_NOTAVAILABLE);
		}
	}
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_HD_AUDIOPRGM::vSendStatus()
{
   vStatus(m_oMessage);
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_HD_AUDIOPRGM::vOnNewATHDAudioProgramStatus(const unsigned char &u8AudioProgram)
{
   m_oMessage.e8HDAudioPrgNo.enType = (midw_fi_tcl_e8_Tun_HDAudioProgram::tenType)u8AudioProgram;
   vSendStatus();
}
