/************************************************************************
 * FILE:           clTmcTuner_Property_G_GET_STATIC_LIST.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Property_G_GET_STATIC_LIST.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
 
 *************************************************************************/


#include "AMFMTuner/clTmcTuner_Property_G_GET_STATIC_LIST.h"
#include "AMFMTuner/clTmcTuner_Method_S_DISABLE_BAND.h"
#include "CcaApp/clCCAhandler.h"
#include "tun_Utility.h"
#include "conversionTable/midwTunerToAdr3Map.h"
#include "ADRMsg/ADRMsg_if.h"
#include "tun_MsgToADR.h"
#include "tun_MsgToHMI.h"
#include "Aars/clAars_ATPresetList_XX.h"
#include "tun_Utility.h"
#include "tun_defines.h"
#include "kdsconfig/clConfigInterface.h"
#include "clTmcTuner_Method_S_JAPAN_SET_AREA.h"
using namespace tuner::CcaApp;

#include "tun_trace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#include "tun_HMIManager.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOHMI
#include "trcGenProj/Header/clTmcTuner_Property_G_GET_STATIC_LIST.cpp.trc.h"
#endif

/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Property_G_GET_STATIC_LIST::~clTmcTuner_Property_G_GET_STATIC_LIST()
{
	m_potun_MsgToHMI=0;
	m_potun_Config=0;
	m_poclTmcTuner_Method_S_DISABLE_BAND=0;
	m_poclAars_ATPresetList_XX=0;
	m_stMixedPresetListCopyForDisableBand.clear();
	m_potun_HMIManager = NULL;
	m_poclConfigInterface=NULL;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Property_G_GET_STATIC_LIST::clTmcTuner_Property_G_GET_STATIC_LIST(tuner::CcaApp::clCCAhandler* poCCAhandler,tun_MsgToHMI* potun_MsgToHMI, tun_Config* potun_Config,tun_HMIManager* potun_HMIManager,clAars_ATPresetList_XX* poclAars_ATPresetList_XX,clConfigInterface* poclConfigInterface)
   : clServerProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_GET_STATIC_LIST, poCCAhandler)
{
	m_potun_MsgToHMI=potun_MsgToHMI;
	m_potun_Config=potun_Config;
	m_poclTmcTuner_Method_S_DISABLE_BAND=0;
	m_poclAars_ATPresetList_XX=poclAars_ATPresetList_XX;
	m_stMixedPresetListCopyForDisableBand.clear();
	m_potun_HMIManager=potun_HMIManager;
	m_poclConfigInterface=poclConfigInterface;
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_GET_STATIC_LIST::vSet(amt_tclServiceData* /*poInMsg*/)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_GET_STATIC_LIST::vGet(amt_tclServiceData* /*poInMsg*/)
{
	tU16 u16FMActivePresetListId = m_potun_MsgToHMI->u16GetFMActivePresetListId();
	tU16 u16AMActivePresetListId = m_potun_MsgToHMI->u16GetAMActivePresetListId();

	  if(ADR_MSG_FID_INVALID!=u16FMActivePresetListId)
	  {
		  m_poclAars_ATPresetList_XX->vGetPresetList(u16FMActivePresetListId);
	  }
	  else
	  {
	  	  u16FMActivePresetListId = U16GetADR3PresetListID((midw_fi_tcl_e8_Tun_TunerBand::tenType)FI_EN_TUN_BAND_FM);
		  m_poclAars_ATPresetList_XX->vGetPresetList(u16FMActivePresetListId);
	  }

	  if(ADR_MSG_FID_INVALID!=u16AMActivePresetListId)
	  {
		  m_poclAars_ATPresetList_XX->vGetPresetList(u16AMActivePresetListId);
	  }
	  else
	  {
	  	  u16AMActivePresetListId = U16GetADR3PresetListID((midw_fi_tcl_e8_Tun_TunerBand::tenType)FI_EN_TUN_BAND_MW);
		  m_poclAars_ATPresetList_XX->vGetPresetList(u16AMActivePresetListId);
	  }	  
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_GET_STATIC_LIST::vUpreg(amt_tclServiceData* /*poInMsg*/)
{
	vGetPresetList();
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_GET_STATIC_LIST::vSendStatus()
{
   //vSendStatus();
}
tVoid clTmcTuner_Property_G_GET_STATIC_LIST::vSetclTmcTuner_Method_S_DISABLE_BANDPtr(clTmcTuner_Method_S_DISABLE_BAND* poclTmcTuner_Method_S_DISABLE_BAND)
{
	m_poclTmcTuner_Method_S_DISABLE_BAND=poclTmcTuner_Method_S_DISABLE_BAND;
}
/*****************************************************************************
*
******************************************************************************/
tVoid clTmcTuner_Property_G_GET_STATIC_LIST::vPopulatePresetList(midw_fi_tcl_TunerStaticListElement &oTunerStaticListElement,
		clCMATPresetList_XX &oData,unsigned char u8Index)
{
	if(m_poclConfigInterface == NULL || m_potun_MsgToHMI == NULL)
	{
		ETG_TRACE_USR4(("m_potun_MsgToHMI null pointer"));
		ETG_TRACE_USR4(("m_poclConfigInterface null pointer"));
		return;
	}
	oTunerStaticListElement.u8ElementID=u8Index;
	oTunerStaticListElement.bSelected=oData.getData(u8Index).PresetSelection;
	oTunerStaticListElement.u32Frequency=oData.getData(u8Index).Frequency;
	tU8 u8SendernameInfo = (tU8)oData.getData(u8Index).StationNameInfo.enType;
	oTunerStaticListElement.e8SendernameInfo.enType=(midw_fi_tcl_e8_Tun_SendernameInfo::tenType)u8SendernameInfo;
	oTunerStaticListElement.u16PI=oData.getData(u8Index).PI;
	oTunerStaticListElement.u32PTY=oData.getData(u8Index).PTY;
	oTunerStaticListElement.u8TpTmcInfo=oData.getData(u8Index).TpTmcInfo;
	oTunerStaticListElement.s8LevelCompensation=oData.getData(u8Index).LevelCompensation;
	tU8 u8ModulationType = (tU8)oData.getData(u8Index).DigitalModulation.enType;
	oTunerStaticListElement.e8Modulation.enType=(midw_fi_tcl_e8_Tun_ModulationType::tenType)u8ModulationType;
	oTunerStaticListElement.u32HDStationId_DRMServiceId=oData.getData(u8Index).HDStationID_DRMServiceID;
	oTunerStaticListElement.e8HDTextEncoding.enType=(midw_fi_tcl_e8_Tun_HD_TextEncodingType::tenType)oData.getData(u8Index).HDTextEncoding;
	oTunerStaticListElement.u8HDStationGenre_DRMPty=oData.getData(u8Index).HDStationGenre_DRMPty;
	oTunerStaticListElement.u8HDAudioProgram_DRMShortID=oData.getData(u8Index).HDProgramNumber_DRMServiceShortId;

	midw_fi_tclString sUtf8String;
	if(oTunerStaticListElement.u16PI != 0)
	{
		m_potun_MsgToHMI->vGetStationLogoPath(oTunerStaticListElement.u16PI , sUtf8String , TRUE);
		oTunerStaticListElement.StationLogo.bSet(  sUtf8String,
                                                        midw_fi_tclString::FI_EN_UTF8);
	}
	midw_fi_tcl_e8_Tun_TunerBand e8Band = m_potun_MsgToHMI->u8GetBandFromFrequency(oTunerStaticListElement.u32Frequency);
	if( (m_poclConfigInterface->u32GetConfigData("HDSupported") == true) && 
		(oTunerStaticListElement.e8Modulation.enType== midw_fi_tcl_e8_Tun_ModulationType::FI_EN_TUN_MODULATION_HD) && 
		(m_potun_MsgToHMI->bIsFMDemodulationON(e8Band.enType) || m_potun_MsgToHMI->bIsAMDemodulationON(e8Band.enType)) &&
		(oTunerStaticListElement.u32HDStationId_DRMServiceId != 0) )
	{
		m_potun_MsgToHMI->vGetActiveHDStationLogoPath(sUtf8String, oTunerStaticListElement.u32HDStationId_DRMServiceId, oTunerStaticListElement.u8HDAudioProgram_DRMShortID);
		oTunerStaticListElement.StationLogo.bSet(  sUtf8String,
                                                        midw_fi_tclString::FI_EN_UTF8);
	}

	vPackPSNameOrHDCallSign_DRMServiceLabel(oTunerStaticListElement,oData,u8Index);
	vTracePresetListElement(oTunerStaticListElement);
}

/*****************************************************************************
*
******************************************************************************/
tVoid clTmcTuner_Property_G_GET_STATIC_LIST::vPackPSNameOrHDCallSign_DRMServiceLabel(midw_fi_tcl_TunerStaticListElement &oTunerStaticListElement,
																					 clCMATPresetList_XX &oData,unsigned char u8Index)
{
	if(m_potun_HMIManager==NULL || m_potun_MsgToHMI==NULL)
	{
		ETG_TRACE_USR4(("HMIManager null pointer"));
		NORMAL_M_ASSERT(m_potun_MsgToHMI != NULL);
		return;
	}
	midw_fi_tclString sUtf8String ;
	if(oTunerStaticListElement.e8Modulation.enType== midw_fi_tcl_e8_Tun_ModulationType::FI_EN_TUN_MODULATION_ANALOG)
	{
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
		if(m_potun_MsgToHMI->poGet_TmcTuner_Method_S_JAPAN_SET_AREAPtr() == NULL)
		{
			ETG_TRACE_USR4(("poGet_TmcTuner_Method_S_JAPAN_SET_AREAPtr is null pointer"));
			return;
		}

		if((m_potun_MsgToHMI->poGet_TmcTuner_Method_S_JAPAN_SET_AREAPtr()->bIsJapanRegion()) && (!(m_potun_MsgToHMI->poGet_TmcTuner_Method_S_JAPAN_SET_AREAPtr()->bIsSuppressStationName())))
		{
			sUtf8String = m_potun_MsgToHMI->poGet_TmcTuner_Method_S_JAPAN_SET_AREAPtr()->sGetStationNameFromDBForListUpdate(oTunerStaticListElement.u32Frequency);
			oTunerStaticListElement.sPSName.bSet(sUtf8String,midw_fi_tclString::FI_EN_UTF8);
		}
		else
		{
#endif
		char apSendername[STATIONNAME_LEN+1] = {0};
		if(!oData.getData(u8Index).Sendername.empty())
		{
			strncpy(apSendername, oData.getData(u8Index).Sendername.c_str(), STATIONNAME_LEN);
			m_potun_HMIManager->vConvertRTextTotString((unsigned char*)apSendername,&sUtf8String,STATIONNAME_LEN);
			oTunerStaticListElement.sPSName.bSet(sUtf8String,midw_fi_tclString::FI_EN_UTF8);
		}
	#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
		}
#endif
	}
	else if((oTunerStaticListElement.e8Modulation.enType== midw_fi_tcl_e8_Tun_ModulationType::FI_EN_TUN_MODULATION_HD) && (midw_fi_tcl_e8_Tun_HD_TextEncodingType::FI_EN_ISO_IEC_8859_1_1998==oTunerStaticListElement.e8HDTextEncoding.enType))
	{
		sUtf8String=oData.getData(u8Index).HDCallSign_DRMServiceLabel.c_str();
		oTunerStaticListElement.sHDCallSign_DRMServiceLabel.bSet(sUtf8String,midw_fi_tclString::FI_EN_ISO8859_1M);
	}
	else if(oTunerStaticListElement.e8Modulation.enType== midw_fi_tcl_e8_Tun_ModulationType::FI_EN_TUN_MODULATION_DRM)
	{
		sUtf8String=oData.getData(u8Index).HDCallSign_DRMServiceLabel.c_str();
		oTunerStaticListElement.sHDCallSign_DRMServiceLabel.bSet(sUtf8String,midw_fi_tclString::FI_EN_UTF8);
	}
}
/*****************************************************************************
*
******************************************************************************/

tVoid clTmcTuner_Property_G_GET_STATIC_LIST::vTracePresetListElement(midw_fi_tcl_TunerStaticListElement &oTunerStaticListElement)
{
	ETG_TRACE_USR4(( "PresetList1 ElementID= %d Selected=%d Frequency=%d SendernameInfo=%d PI=%d", 
		oTunerStaticListElement.u8ElementID,oTunerStaticListElement.bSelected,oTunerStaticListElement.u32Frequency,oTunerStaticListElement.e8SendernameInfo.enType,oTunerStaticListElement.u16PI));
	ETG_TRACE_USR4(( "PresetList2 PTY= %d TpTmcInfo=%d LevelCompensation=%d Modulation=%d HDStationId_DRMServiceId=%d HDTextEncoding=%d HDStationGenre_DRMPty=%d HDAudioProgram_DRMShortID=%d", 
			oTunerStaticListElement.u32PTY,oTunerStaticListElement.u8TpTmcInfo,oTunerStaticListElement.s8LevelCompensation,oTunerStaticListElement.e8Modulation.enType,\
			oTunerStaticListElement.u32HDStationId_DRMServiceId,oTunerStaticListElement.e8HDTextEncoding.enType,oTunerStaticListElement.u8HDStationGenre_DRMPty,oTunerStaticListElement.u8HDAudioProgram_DRMShortID));
	ETG_TRACE_USR4(( "PresetList3 PSName=%s", oTunerStaticListElement.sPSName.szGet(midw_fi_tclString::FI_EN_UTF8)));
	ETG_TRACE_USR4(( "PresetList4 HDCallSign_DRMServiceLabel=%s", oTunerStaticListElement.sHDCallSign_DRMServiceLabel.szGet(midw_fi_tclString::FI_EN_UTF8)));
	ETG_TRACE_USR4(( "PresetList5 StationLogo = %s", oTunerStaticListElement.StationLogo.szGet(midw_fi_tclString::FI_EN_UTF8)));
}
/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_GET_STATIC_LIST::vOnCMATPresetList_XX_Status(clCMATPresetList_XX &oData,short u16FunctionId)
{
	if((NULL==m_poclTmcTuner_Method_S_DISABLE_BAND) || (NULL==m_potun_Config)||(NULL==m_potun_MsgToHMI))
	{
		return;
	}
	stDisableBandRequest ostDisableBandRequest=m_poclTmcTuner_Method_S_DISABLE_BAND->stGetDisableBandRequested();
	ETG_TRACE_USR4(( "vOnCMATPresetList_XX_Status()->Is DisableBandRequested =%d",ostDisableBandRequest.blIsDisableBandRequested));
	if(ostDisableBandRequest.blIsDisableBandRequested)
	{
		if(!bIsDeletedPresetsElementsSuccess(oData,u16FunctionId))
		return;
	}
	midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTStatus oMessage;
	unsigned char NumberOfPresets = 0;
    if(TUN_CONFIG_PRESETLIST_TYPE_MIXED== m_potun_Config->u8GetPresetListType())
    {
		oMessage.e8ListID.enType = midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_MIX1;
		m_stMixedPresetListCopyForDisableBand.clear();
		NumberOfPresets = m_potun_Config->u8GetNoOfPresetsPerBank(midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_MIX1);
    }
	else
	{
		oMessage.e8ListID.enType =oGetADR3ToMidwTunerPresetListID((tun_tenAmFmTunerMsg)u16FunctionId);
		NumberOfPresets = m_potun_Config->u8GetNoOfPresetsPerBank(oGetADR3ToMidwTunerPresetListID((tun_tenAmFmTunerMsg)u16FunctionId));
	}
	oMessage.u8NumofElementsinList= NumberOfPresets;
	for(tU8 u8Index = 1;u8Index<=oMessage.u8NumofElementsinList;u8Index++)
	{
		midw_fi_tcl_TunerStaticListElement oTunerStaticListElement;
		vPopulatePresetList(oTunerStaticListElement,oData,u8Index);
		oMessage.Tun_StaticListElements.TunerStaticListElement.push_back(oTunerStaticListElement);
		if(TUN_CONFIG_PRESETLIST_TYPE_MIXED== m_potun_Config->u8GetPresetListType())
		{
			stMixedPresetListCopyForDisableBand ostMixedPresetListCopyForDisableBand;
			ostMixedPresetListCopyForDisableBand.u8PresetEleNo=u8Index;
			ostMixedPresetListCopyForDisableBand.u32Frequency=oData.getData(u8Index).Frequency;
			m_stMixedPresetListCopyForDisableBand.push_back(ostMixedPresetListCopyForDisableBand);
		}
	}
	vStatus(oMessage);
	if(m_potun_MsgToHMI->blGetSendAutoStoreMethodeResult())
	{
		m_potun_MsgToHMI->vSetSendAutoStoreMethodeResult(false);
		m_potun_MsgToHMI->vSendAutostoreMethodResult(midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED,\
			AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
	}
}
/*****************************************************************************
*
******************************************************************************/
void clTmcTuner_Property_G_GET_STATIC_LIST::vDisableBand_DeletePresetElement(midw_fi_tcl_e8_Tun_TunerBand::tenType enBand)
{
	if((m_potun_Config==NULL) || (NULL==m_poclAars_ATPresetList_XX))
	{
		return;
	}
	tU32 u32StartFreq=0;
	tU32 u32EndFreq=0;
	m_potun_Config->vGetFrequencyRangeToDeleteElement(u32StartFreq,u32EndFreq,enBand);
	if(u32StartFreq!=0 && u32EndFreq!=0)
	{
		tunerVector<stMixedPresetListCopyForDisableBand>::iterator itr = m_stMixedPresetListCopyForDisableBand.begin();
		while(itr!=m_stMixedPresetListCopyForDisableBand.end())
		{
			if((itr->u32Frequency>=u32StartFreq)&& (itr->u32Frequency<=u32EndFreq))
			{
				ETG_TRACE_USR4(("delete element %d",itr->u8PresetEleNo ));
				m_poclAars_ATPresetList_XX->vDeleteSinglePresetElement(U16GetADR3PresetListID(enBand),itr->u8PresetEleNo);
			}
			itr++;
		}
	}
}
/*****************************************************************************
*
******************************************************************************/
tBool clTmcTuner_Property_G_GET_STATIC_LIST::bIsDeletedPresetsElementsSuccess(clCMATPresetList_XX &oData,short u16FunctionId)
{
	if((NULL==m_poclTmcTuner_Method_S_DISABLE_BAND) ||(NULL==m_poclAars_ATPresetList_XX) || (NULL==m_potun_Config))
	{
		return false;
	}
	tBool blAllPresetDeleted=false;
	stDisableBandRequest ostDisableBandRequest = m_poclTmcTuner_Method_S_DISABLE_BAND->stGetDisableBandRequested();
	//Mixed PresetList
	//if(midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_MIX1==oGetADR3ToMidwTunerPresetListID(u16FunctionId))
	if(m_potun_Config->u8GetPresetListType() ==TUN_CONFIG_PRESETLIST_TYPE_MIXED)
	{
		blAllPresetDeleted=blCheckIsMixedPreseteElemDeleted(oData,u16FunctionId);
	}
	//Normal preset list, compare the request disable band with the preset list status band
	else if(ostDisableBandRequest.midwTunerBand == oGetADR3ToMidwTunerBand((tun_tenAmFmTunerMsg)u16FunctionId))
	{
		blAllPresetDeleted=blCheckIsAllPresetElementsDeleted(oData,u16FunctionId);
	}
	ETG_TRACE_USR4(("AllPresetDeleted=%d",blAllPresetDeleted));
	if(!blAllPresetDeleted)
	{
		//If preset are not deleted, request for the presetlist to to delete the non deleted preset elements
		m_poclAars_ATPresetList_XX->vGetPresetList(u16FunctionId);
	}
	else
	{
		m_poclTmcTuner_Method_S_DISABLE_BAND->vSendDisableBandMethodResult();
	}
	return blAllPresetDeleted;
}
/*****************************************************************************
*
******************************************************************************/
tBool clTmcTuner_Property_G_GET_STATIC_LIST::blCheckIsMixedPreseteElemDeleted(clCMATPresetList_XX &oData,short u16FunctionId)
{
	if((NULL==m_potun_Config) || (NULL==m_poclAars_ATPresetList_XX) || (NULL==m_poclTmcTuner_Method_S_DISABLE_BAND))
	{
		return false;
	}
	tU8 u8NumberOfPresets = m_potun_Config->u8GetNoOfPresetsPerBank(oGetADR3ToMidwTunerPresetListID((tun_tenAmFmTunerMsg)u16FunctionId));
	for(tU8 u8Index = 1;u8Index<=u8NumberOfPresets;u8Index++)
	{
		tU32 u32StartFreq=0;
		tU32 u32EndFreq=0;
		stDisableBandRequest ostDisableBandRequest=m_poclTmcTuner_Method_S_DISABLE_BAND->stGetDisableBandRequested();
		m_potun_Config->vGetFrequencyRangeToDeleteElement(u32StartFreq,u32EndFreq,ostDisableBandRequest.midwTunerBand);
		//Preset elements doesn't belong to requuested disable band
		if((oData.getData(u8Index).Frequency >u32EndFreq) || (oData.getData(u8Index).Frequency ==0))
		{
				
		}
		//Delete the preset element belongs to requested disable band
		else
		{
			m_poclAars_ATPresetList_XX->vDeleteSinglePresetElement(u16FunctionId,u8Index);
			return false;
		}
	}
	return true;
}
/*****************************************************************************
*
******************************************************************************/
tBool clTmcTuner_Property_G_GET_STATIC_LIST::blCheckIsAllPresetElementsDeleted(clCMATPresetList_XX &oData,short u16FunctionId)
{
	if((NULL==m_potun_Config) || (NULL==m_poclAars_ATPresetList_XX))
	{
		return false;
	}
	tU8 u8NumberOfPresets = m_potun_Config->u8GetNoOfPresetsPerBank(oGetADR3ToMidwTunerPresetListID((tun_tenAmFmTunerMsg)u16FunctionId));
	for(tU8 u8Index = 1;u8Index<=u8NumberOfPresets;u8Index++)
	{
		if(oData.getData(u8Index).Frequency !=0)
		{
			m_poclAars_ATPresetList_XX->vDeleteSinglePresetElement(u16FunctionId,u8Index);
			return false;
		}
	}
	return true;
}
tVoid clTmcTuner_Property_G_GET_STATIC_LIST::vGetPresetList()
{
	tU16 u16FMActivePresetListId = m_potun_MsgToHMI->u16GetFMActivePresetListId();
	tU16 u16AMActivePresetListId = m_potun_MsgToHMI->u16GetAMActivePresetListId();
	if(m_poclConfigInterface != NULL)
	{
		if(m_poclConfigInterface->u32GetConfigData("PresetListType"))
		{
			m_poclAars_ATPresetList_XX->vGetPresetList(u16FMActivePresetListId);
			return;
		}
		else
		{
			if(ADR_MSG_FID_INVALID!=u16FMActivePresetListId)
			{
			  m_poclAars_ATPresetList_XX->vGetPresetList(u16FMActivePresetListId);
			}
			else
			{
			  u16FMActivePresetListId = U16GetADR3PresetListID((midw_fi_tcl_e8_Tun_TunerBand::tenType)FI_EN_TUN_BAND_FM);
			  m_poclAars_ATPresetList_XX->vGetPresetList(u16FMActivePresetListId);
			}

			if(ADR_MSG_FID_INVALID!=u16AMActivePresetListId)
			{
			  m_poclAars_ATPresetList_XX->vGetPresetList(u16AMActivePresetListId);
			}
			else
			{
			  u16AMActivePresetListId = U16GetADR3PresetListID((midw_fi_tcl_e8_Tun_TunerBand::tenType)FI_EN_TUN_BAND_MW);
			  m_poclAars_ATPresetList_XX->vGetPresetList(u16AMActivePresetListId);
			}
		}
	}
}
