/************************************************************************
 * FILE:           clTmcTuner_Property_G_GET_DARC_DATA.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clTmcTuner_Property_G_GET_DARC_DATA.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  Sep 30, 2016         auj1kor
 *************************************************************************/



#ifndef CLTMCTUNER_PROPERTY_G_GET_DARC_DATA_H_
#define CLTMCTUNER_PROPERTY_G_GET_DARC_DATA_H_

#include "CcaApp/clServerProperty.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "interface/clTmcTuner_HMI_ImpInterface.h"
#include "ADRMsg/ADRMsg_if.h"

#define TUN_DARC_TIMEOUT_MS 15000
#define TUN_DARC_DATA_BLOCKSIZE	36
#define TUN_DARC_READDATA_SIZE	22
#define TUN_DARCDATA_STARTBYTE	13

#define TUN_ASSERT_RETURN(expr)                 \
    if (!(expr)) {                              \
        NORMAL_M_ASSERT_ALWAYS();               \
        return;                                 \
    }


class clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST;

class clTmcTuner_Property_G_GET_DARC_DATA : public  tuner::CcaApp::clServerProperty, public clTmcTuner_HMI_ImpInterface
{
   public:
      virtual ~clTmcTuner_Property_G_GET_DARC_DATA();
      clTmcTuner_Property_G_GET_DARC_DATA( tuner::CcaApp::clCCAhandler* poCCAhandler);
      void vSet_G_GET_DARC_DATA_Ptr(clTmcTuner_Property_G_GET_DARC_DATA* poclTmcTuner_Property_G_GET_DARC_DATA);
      void vSet_S_DARC_VICS_FREQUENCY_LIST(clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST* poclTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST);
      virtual void vOnCM_DARCDataStatus(clCMDARCGetDataStatus &oDARCDataStatus);
	  void vStartDARCTimer();
      void vStopDARCTimer();

      OSAL_tTimerHandle  m_hTimerDARCAvail;

   protected:
      virtual void vGet(amt_tclServiceData* poInMsg);
      virtual void vSet(amt_tclServiceData* poInMsg);
      virtual void vUpreg(amt_tclServiceData* poInMsg);

   private:

      static tVoid vDARCAvailTimerCallback(tVoid* pArg);
      static clTmcTuner_Property_G_GET_DARC_DATA* _theServer;

      clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST* m_poclTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST;

};



#endif /* CLTMCTUNER_PROPERTY_G_GET_DARC_DATA_H_ */
