/************************************************************************
 * FILE:           clTmcTuner_Property_G_GET_CONFIG_LIST.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification

 *************************************************************************/

#include "AMFMTuner/clTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID.h"
#include "CcaApp/clCCAhandler.h"
#include "tun_MsgToHMI.h"
#include "conversionTable/midwTunerToAdr3Map.h"
#include "tun_trace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOHMI
#include "trcGenProj/Header/clTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID.cpp.trc.h"
#endif
using namespace tuner::CcaApp;

/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID::~clTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID()
{
	m_potun_MsgToHMI = NULL;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID::clTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID(clCCAhandler* poCCAhandler , tun_MsgToHMI* potun_MsgToHMI)
   : clServerProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_GET_ACTIVE_PRESETLISTID, poCCAhandler)
{
	m_potun_MsgToHMI = potun_MsgToHMI;
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID::vSet(amt_tclServiceData* /*poInMsg*/)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID::vGet(amt_tclServiceData* /*poInMsg*/)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID::vUpreg(amt_tclServiceData* /*poInMsg*/)
{
	vSendActivePresetListID();
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID::vSendActivePresetListID()
{
	if(m_potun_MsgToHMI != NULL)
	{
		if((m_potun_MsgToHMI->u16GetFMActivePresetListId() != 0) && (m_potun_MsgToHMI->u16GetAMActivePresetListId() != 0))
		{
		    midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus oMessage;
			oMessage.AMPresetListID.enType = oGetADR3ToMidwTunerPresetListID(m_potun_MsgToHMI->u16GetAMActivePresetListId());
			oMessage.FMPresetListID.enType = oGetADR3ToMidwTunerPresetListID(m_potun_MsgToHMI->u16GetFMActivePresetListId());
			ETG_TRACE_USR4(("vSendActivePresetListID, FM Preset List ID : %d ",(tU8)oMessage.FMPresetListID.enType));
			ETG_TRACE_USR4(("vSendActivePresetListID, AM Preset List ID : %d ",(tU8)oMessage.AMPresetListID.enType));
			vStatus(oMessage);
		}
	}
}

