/************************************************************************
 * FILE:           clTmcTuner_Property_DemodulationSwitchStatus.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Property_DemodulationSwitchStatus.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  
 *************************************************************************/


#ifndef clTmcTuner_Property_DemodulationSwitchStatus_h
#define clTmcTuner_Property_DemodulationSwitchStatus_h


#include "CcaApp/clServerProperty.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "interface/clTmcTuner_HMI_ImpInterface.h"
#include "ADRMsg/ADRMsg_if.h"

class clAars_DemodulationSwitch;
class tun_MsgToHMI;
class clTmcTuner_Method_SetDemodulationSwitch;
class clTmcTuner_Property_DemodulationSwitchStatus : public  tuner::CcaApp::clServerProperty, public clTmcTuner_HMI_ImpInterface
{
   public:
      virtual ~clTmcTuner_Property_DemodulationSwitchStatus();
      clTmcTuner_Property_DemodulationSwitchStatus( tuner::CcaApp::clCCAhandler* poCCAhandler, clAars_DemodulationSwitch* poDemodulationSwitch, tun_MsgToHMI* potun_MsgToHMI, clTmcTuner_Method_SetDemodulationSwitch* poclTmcTuner_Method_SetDemodulationSwitch);
	  virtual tVoid vOnNewDemodulationStatus(unsigned char u8DemodulationSwitch);
	  virtual tVoid vOnNewDemodulationError(clCMError &oData);

   protected:
      virtual tVoid vGet(amt_tclServiceData* poInMsg);
      virtual tVoid vSet(amt_tclServiceData* poInMsg);
      virtual tVoid vUpreg(amt_tclServiceData* poInMsg);

   private:
	   
      clAars_DemodulationSwitch* m_poDemodulationSwitch;
	  tun_MsgToHMI* m_potun_MsgToHMI;
	  clTmcTuner_Method_SetDemodulationSwitch* m_poclTmcTuner_Method_SetDemodulationSwitch;

      /*tVoid vSendStatus();*/

};

#endif
