/************************************************************************
 * FILE:           clTmcTuner_Property_DemodulationSwitchStatus.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Property_DemodulationSwitchStatus.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  
 *************************************************************************/


#include "AMFMTuner/clTmcTuner_Property_DemodulationSwitchStatus.h"
#include "AMFMTuner/clTmcTuner_Method_SetDemodulationSwitch.h"
#include "CcaApp/clCCAhandler.h"
#include "Aars/clAars_DemodulationSwitch.h"
#include "tun_MsgToHMI.h"

#include "tuner_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Property_DemodulationSwitchStatus.cpp.trc.h"
#endif
using namespace tuner::CcaApp;


/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Property_DemodulationSwitchStatus::~clTmcTuner_Property_DemodulationSwitchStatus()
{
	 m_poDemodulationSwitch = NULL;
	 m_potun_MsgToHMI = NULL;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Property_DemodulationSwitchStatus::clTmcTuner_Property_DemodulationSwitchStatus(clCCAhandler* poCCAhandler, clAars_DemodulationSwitch* poDemodulationSwitch,
	tun_MsgToHMI* potun_MsgToHMI, clTmcTuner_Method_SetDemodulationSwitch* poclTmcTuner_Method_SetDemodulationSwitch)
   : clServerProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_DEMODULATION_SWITCH_STATUS, poCCAhandler)
   ,m_poDemodulationSwitch(poDemodulationSwitch)
   ,m_potun_MsgToHMI(potun_MsgToHMI)
   ,m_poclTmcTuner_Method_SetDemodulationSwitch(poclTmcTuner_Method_SetDemodulationSwitch)
{
 
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_DemodulationSwitchStatus::vSet(amt_tclServiceData* /*poInMsg*/)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_DemodulationSwitchStatus::vGet(amt_tclServiceData* /*poInMsg*/)
{
    m_poDemodulationSwitch->vGetDemodulationSwitch();
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_DemodulationSwitchStatus::vUpreg(amt_tclServiceData* /*poInMsg*/)
{
   m_poDemodulationSwitch->vGetDemodulationSwitch();
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_DemodulationSwitchStatus::vOnNewDemodulationStatus(unsigned char u8DemodulationSwitch)
{
	if(m_potun_MsgToHMI != NULL)
	{
		m_potun_MsgToHMI->vOnNewDemodulationStatus(u8DemodulationSwitch);
	}
	/*Fix for RTC bug 99115 */
	if(m_poclTmcTuner_Method_SetDemodulationSwitch != NULL)
	{
		m_poclTmcTuner_Method_SetDemodulationSwitch->vSendSetDemodulationSwitchMethodResult(midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED);
	}
   midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus oMessage;
   oMessage.DemodulationSwitch.u8Value = u8DemodulationSwitch;
   vStatus(oMessage);
}
tVoid clTmcTuner_Property_DemodulationSwitchStatus::vOnNewDemodulationError(clCMError &oData)
{
	ETG_TRACE_USR4(( "clTmcTuner_Method_SetDemodulationSwitch::vOnNewDemodulationError(), ErrorCode:%d ,ErrorInfo: %d, ", oData.getErrorCode(), oData.getErrorInfo()));
	if(m_poclTmcTuner_Method_SetDemodulationSwitch != NULL)
	{
		m_poclTmcTuner_Method_SetDemodulationSwitch->vSendSetDemodulationSwitchMethodResult(midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL);
	}
}