/************************************************************************
 * FILE:           clTmcTuner_Property_AtPiSearch.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Property_AtPiSearch.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  
 *************************************************************************/

#include "AMFMTuner/clTmcTuner_Property_AtPiSearch.h"
#include "CcaApp/clCCAhandler.h"
#include "Aars/clAars_AtPiSearch.h"


using namespace tuner::CcaApp;


/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Property_AtPiSearch::~clTmcTuner_Property_AtPiSearch()
{
	 m_poAtPiSearch = NULL;
	 m_oMessage.e8PISearchStatus.enType = midw_fi_tcl_e8_PISearch_Status::FI_EN_IDLE;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Property_AtPiSearch::clTmcTuner_Property_AtPiSearch(clCCAhandler* poCCAhandler, clAars_AtPiSearch* poAtPiSearch)
   : clServerProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_ATPISEARCH, poCCAhandler)
   ,m_poAtPiSearch(poAtPiSearch)
{
	m_oMessage.e8PISearchStatus.enType = midw_fi_tcl_e8_PISearch_Status::FI_EN_IDLE;
}



/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_AtPiSearch::vUpreg(amt_tclServiceData* /*poInMsg*/)
{
   //midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHStatus m_oMessage;
   vStatus(m_oMessage);
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_AtPiSearch::vOnNewAtPiSearchStatus(unsigned char u8PiSearchStatus)
{
   m_oMessage.e8PISearchStatus.enType = (midw_fi_tcl_e8_PISearch_Status::tenType)u8PiSearchStatus;
   vStatus(m_oMessage);
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_AtPiSearch::vSet(amt_tclServiceData* /*poInMsg*/)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_AtPiSearch::vGet(amt_tclServiceData* /*poInMsg*/)
{
    
}
