/************************************************************************
 * FILE:          clTmcTuner_Method_SetDrmSrcActivity.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_SetDrmSrcActivity.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  
 *************************************************************************/





#include "AMFMTuner/clTmcTuner_Method_SetDrmSrcActivity.h"
#include "CcaApp/clCCAhandler.h"
#include "drmPlayer/drmPlayerInterface.h"


using namespace tuner::drm;
using namespace tuner::CcaApp;


/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Method_SetDrmSrcActivity::~clTmcTuner_Method_SetDrmSrcActivity()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Method_SetDrmSrcActivity::clTmcTuner_Method_SetDrmSrcActivity(clCCAhandler* poCCAhandler)
   : clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_SET_DRM_SRCACTIVITY, poCCAhandler)
{
}


/**************************************************************************//**
* 
******************************************************************************/
tVoid clTmcTuner_Method_SetDrmSrcActivity::vMethodStart(amt_tclServiceData* poInMessage )
{
   midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodStart oMessage;
   m_poCCAhandler->vGetDataFromAmt(poInMessage, oMessage);
   vOnNewSrcActivity(oMessage.e8DRMSourceActivity);
}


/**************************************************************************//**
* 
******************************************************************************/
tVoid clTmcTuner_Method_SetDrmSrcActivity::vOnNewSrcActivity(midw_fi_tcl_e8_Tun_DRMSourceActivity& srcActivity)
{
   drmPlayerInterface* player = drmPlayerInterface::getInstance();
   if (0 != player)
   {
      if (srcActivity.enType == midw_fi_tcl_e8_Tun_DRMSourceActivity::FI_EN_ON)
      {
         player->vSetPlayerState(true);
         player->bPlay();
      }
      else
      {
         player->vSetPlayerState(false);
         player->vDeletePlayer();
      }
   }
	midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodResult oResult;
	vSendMethodResult(oResult);
}

