/************************************************************************
 * FILE:          clTmcTuner_Method_SetDemodulationSwitch.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_SetDemodulationSwitch.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  
 *************************************************************************/



#include "AMFMTuner/clTmcTuner_Method_SetDemodulationSwitch.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "CcaApp/clCCAhandler.h"
#include "tun_ActualData.h"
#include "Aars/clAars_ATPresetList_XX.h"
#include "drmPlayer/drmPlayerInterface.h"
#include "Aars/clAars_DemodulationSwitch.h"

#include "tuner_trace.h"

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Method_SetDemodulationSwitch.cpp.trc.h"
#endif

using namespace tuner::drm;
using namespace tuner::CcaApp;

/*****************************************************************************
* Destructor
******************************************************************************/
clTmcTuner_Method_SetDemodulationSwitch::~clTmcTuner_Method_SetDemodulationSwitch()
{
    m_poDemodulationSwitch = NULL;
    m_potun_ActualData = NULL;
    m_poATPresetList_XX = NULL;
}


/******************************************************************************
* Constructor
******************************************************************************/
clTmcTuner_Method_SetDemodulationSwitch::clTmcTuner_Method_SetDemodulationSwitch(clCCAhandler* poCCAhandler, \
	clAars_DemodulationSwitch* poDemodulationSwitch,tun_ActualData* po_tun_ActualData,clAars_ATPresetList_XX* poATPresetList_XX)
   : clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_SET_DEMODULATION_SWITCH, poCCAhandler)
     ,m_poDemodulationSwitch(poDemodulationSwitch)
	 ,m_potun_ActualData(po_tun_ActualData)
	 ,m_poATPresetList_XX(poATPresetList_XX)
{
   
}


/*****************************************************************************
*
******************************************************************************/
tVoid clTmcTuner_Method_SetDemodulationSwitch::vMethodStart(amt_tclServiceData* poInMessage )
{
	m_poCCAhandler->vGetDataFromAmt(poInMessage, m_oMessage);

	vSendDemodulationRequestToAars();
	
    
}


tVoid clTmcTuner_Method_SetDemodulationSwitch::vSendDemodulationRequestToAars()
{
	ETG_TRACE_USR4(("clTmcTuner_Method_SetDemodulationSwitch: vSendDemodulationRequestToAars : Mask : %d, Value : %d",\
		m_oMessage.b8DemodulationSwitchMask.u8Value,m_oMessage.b8DemodulationSwitchValue.u8Value));
	unsigned char u8DemodulationSwitch = m_poDemodulationSwitch->u8GetAarsDemodulationSwitch();

	u8DemodulationSwitch = (unsigned char)( (m_oMessage.b8DemodulationSwitchMask.u8Value & m_oMessage.b8DemodulationSwitchValue.u8Value) ? \
		u8DemodulationSwitch | m_oMessage.b8DemodulationSwitchMask.u8Value :
		u8DemodulationSwitch & ~ m_oMessage.b8DemodulationSwitchMask.u8Value );

    m_poDemodulationSwitch->vSetDemodulationSwitch(u8DemodulationSwitch);

}


/*Fix for RTC bug 99115 */
tVoid clTmcTuner_Method_SetDemodulationSwitch::vSendSetDemodulationSwitchMethodResult(midw_fi_tcl_e8_Tun_ResponseStatus::tenType oResStatus)
{
	midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodResult oResult;
	oResult.TunerServer_StatusResponse.u8TunerStatus.enType = oResStatus;

	vSendMethodResult(oResult);
}
