/************************************************************************
 * FILE:           clTmcTuner_Method_S_USER_PROFILE_UPDATE.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_USER_PROFILE_UPDATE.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author          aso9kor             | Modification

 *************************************************************************/

#ifndef clTmcTuner_Method_S_USER_PROFILE_UPDATE_h
#define clTmcTuner_Method_S_USER_PROFILE_UPDATE_h

#include "CcaApp/clServerMethod.h"
#include "ADRMsg/ADRMsg_if.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "interface/clTmcTuner_HMI_ImpInterface.h"

class clAars_CM_SetUserOptions;
class clAars_ATPresetList_XX;
class clAars_CM_CopyUserContent;
class tun_MsgToADR;

class clTmcTuner_Method_S_USER_PROFILE_UPDATE : public tuner::CcaApp::clServerMethod, public clTmcTuner_HMI_ImpInterface
{
public:
    virtual ~clTmcTuner_Method_S_USER_PROFILE_UPDATE();
    clTmcTuner_Method_S_USER_PROFILE_UPDATE( tuner::CcaApp::clCCAhandler* poCCAhandler, clAars_CM_SetUserOptions* poSetUserOptions,clAars_CM_CopyUserContent* poCopyUserContent, clAars_ATPresetList_XX* poATPresetList_XX);
    virtual void vOnNewCMSetUserOptionsStatus(unsigned char u8UserId, unsigned int u32UserOptions);
    virtual tVoid vOnCM_SetUserOptionsError(clCMError &oData);
    virtual tVoid vOnCM_CopyUserContentError(clCMError &oData);
    virtual tVoid vOnCopyUserContentResult();
    void vSetActivePresetList(tU16 u16ActivePresetList);
    tVoid vOnDeleteProfileResult(tU8 u8Status);
    void vSet_tun_MsgToADR_Ptr(tun_MsgToADR* potun_MsgToADR);
private:
    clAars_ATPresetList_XX* m_poATPresetList_XX;

    clAars_CM_SetUserOptions* m_poSetUserOptions;
    clAars_CM_CopyUserContent* m_poCopyUserContent;
    virtual tVoid vMethodStart(amt_tclServiceData* poInMsg);
    unsigned short m_u16RegisterID;
    unsigned short m_u16CmdCounter;
    unsigned short m_u16DestAppID;
	tU16 m_u16ActivePresetList;
	tBool m_bDeleteRequestSent;
    tBool m_bProfileChangeRequestSent;
    tBool m_bProfileCopyRequestSent;
	tun_MsgToADR* m_potun_MsgToADR;
};


#endif
