/************************************************************************
 * FILE:          clTmcTuner_Method_S_TESTMODE.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_TESTMODE.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  
 *************************************************************************/



#include "AMFMTuner/clTmcTuner_Method_S_TESTMODE.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "CcaApp/clCCAhandler.h"
#include "Aars/clAars_EnhancedTestMode.h"
#include "Aars/clAars_HDTestMode.h"

#ifdef VARIANT_S_FTR_ENABLE_DRM
#include "Aars/clAars_DRMTestMode.h"
#endif

#include "tuner_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Method_S_TESTMODE.cpp.trc.h"
#endif

enum TestModeSource
{
	TUN_TEST_MODE_SOURCE_ANALOG_AMFM = 0,
	TUN_TEST_MODE_SOURCE_HD,
	TUN_TEST_MODE_SOURCE_DRM,
	TUN_TEST_MODE_SOURCE_INVALID = 255
};

//using namespace tuner::drm;
using namespace tuner::CcaApp;

/*****************************************************************************
* Destructor
******************************************************************************/
clTmcTuner_Method_TestMode::~clTmcTuner_Method_TestMode()
{

    m_poEnhancedTestMode = NULL;
	m_poclAars_HDTestMode = NULL;
#ifdef VARIANT_S_FTR_ENABLE_DRM
	m_poclAars_DRMTestMode = NULL;
#endif
}


/******************************************************************************
* Constructor
******************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_DRM
clTmcTuner_Method_TestMode::clTmcTuner_Method_TestMode(clCCAhandler* poCCAhandler, clAars_EnhancedTestMode* poEnhancedTestMode
	,clAars_HDTestMode* poclAars_HDTestMode, clAars_DRMTestMode* poclAars_DRMTestMode)
#else
clTmcTuner_Method_TestMode::clTmcTuner_Method_TestMode(clCCAhandler* poCCAhandler, clAars_EnhancedTestMode* poEnhancedTestMode
	,clAars_HDTestMode* poclAars_HDTestMode)
#endif
   : clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_SET_TESTMODE, poCCAhandler)
     ,m_poEnhancedTestMode(poEnhancedTestMode)
	 ,m_poclAars_HDTestMode(poclAars_HDTestMode)
#ifdef VARIANT_S_FTR_ENABLE_DRM
	 ,m_poclAars_DRMTestMode(poclAars_DRMTestMode)
#endif
{

}


/*****************************************************************************
*
******************************************************************************/
tVoid clTmcTuner_Method_TestMode::vMethodStart(amt_tclServiceData* poInMessage )
{
   ETG_TRACE_USR1(("CCR.STARTING.TESTMODE_DATA:MethodStart"));
   ETG_TRACE_USR4(("clTmcTuner_Method_TestMode: MethodStart"));
   m_poCCAhandler->vGetDataFromAmt(poInMessage, m_oMessage);

   vSendTestModeRequestToAars();
   midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodResult oResult;
   vSendMethodResult(oResult);
}

tVoid clTmcTuner_Method_TestMode::vSendTestModeRequestToAars()
{
   unsigned char u8TestModeActivity = m_oMessage.e8TestModeActivity.enType;
   clCMEnum_TestmodeActivity EnhancedTestModeActivity;
   EnhancedTestModeActivity.enType = static_cast<clCMEnum_TestmodeActivity::enTestmodeActivity> (u8TestModeActivity);
   
   unsigned char u8TestModeSource = (unsigned char)m_oMessage.e8TestModeSource.enType;
   
   switch(u8TestModeSource)
   {
   case TUN_TEST_MODE_SOURCE_ANALOG_AMFM:
	   {
		   m_poEnhancedTestMode->vSetEnhancedTestModeActivity(EnhancedTestModeActivity);
	   }
	   break;

   case TUN_TEST_MODE_SOURCE_HD:
	   {
		    m_poclAars_HDTestMode->vSetHDTestMode(u8TestModeActivity);
	   }
	   break;

#ifdef VARIANT_S_FTR_ENABLE_DRM
   case TUN_TEST_MODE_SOURCE_DRM:
	   {
		    m_poclAars_DRMTestMode->vSetDRMTestModeActivity(EnhancedTestModeActivity);
	   }
	   break;
#endif
   case TUN_TEST_MODE_SOURCE_INVALID:
   default :
	   break;
   }

   ETG_TRACE_USR4(("vSendTestModeRequestToAars: Source = %d, Activity = %d",u8TestModeSource,u8TestModeActivity));

}


