/************************************************************************
 * FILE:          clTmcTuner_Method_S_STATIONLIST_EXIT.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_STATIONLIST_EXIT.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  
 *************************************************************************/


#ifndef clTmcTuner_Method_S_STATIONLIST_EXIT_h
#define clTmcTuner_Method_S_STATIONLIST_EXIT_h


#include "CcaApp/clServerMethod.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "interface/clTmcTuner_HMI_ImpInterface.h"
#include "TunerApp/Mute/MuteHandling/clMuteImpl.h"
#include "clTmcTuner_Method_S_GET_CONFIG_LIST.h"

class clAars_CM_StationListRelease;

namespace Mute
{
	namespace MuteHandling
	{
		class clMuteImpl;
	}
}

class clTmcTuner_Method_S_STATIONLIST_EXIT : public tuner::CcaApp::clServerMethod, public clTmcTuner_HMI_ImpInterface
{
public:
	virtual ~clTmcTuner_Method_S_STATIONLIST_EXIT();
	clTmcTuner_Method_S_STATIONLIST_EXIT( tuner::CcaApp::clCCAhandler* poCCAhandler,clAars_CM_StationListRelease* poclAars_CM_StationListRelease
		,clTmcTuner_Method_S_GET_CONFIG_LIST* poclTmcTuner_Method_S_GET_CONFIG_LIST);
	bool bIsStationListExitRequired(midw_fi_tcl_e8_Tun_ConfigListID::tenType e8ListId);
	//bool bIsStationListExitRequired();
	bool bIsStationListExitRequested(midw_fi_tcl_e8_Tun_ConfigListID::tenType e8ListId);
	void vClearStationListExitRequested(midw_fi_tcl_e8_Tun_ConfigListID::tenType e8ListId);
	void vClearAllStationListExitRequests();
	void vSendStationListExit(midw_fi_tcl_e8_Tun_ConfigListID::tenType e8ListId);
	void vIncrementNoOfStationlistExitRequests(midw_fi_tcl_e8_Tun_ConfigListID::tenType e8ListId);
	void vDecrementNoOfStationlistExitRequests(midw_fi_tcl_e8_Tun_ConfigListID::tenType e8ListId);
	void vSetConfigListId(midw_fi_tcl_e8_Tun_ConfigListID::tenType e8ListId);

protected:
private:
	midw_fi_tcl_e8_Tun_ConfigListID::tenType m_e8ConfigListID;
	unsigned char m_u8NumberOfAMStationlistExitRequests;
	unsigned char m_u8NumberOfFMStationlistExitRequests;
	virtual tVoid vMethodStart(amt_tclServiceData* poInMsg);
	clAars_CM_StationListRelease* m_poclAars_CM_StationListRelease;
	Mute::MuteHandling::clMuteImpl* muteImpl;
	clTmcTuner_Method_S_GET_CONFIG_LIST* m_poclTmcTuner_Method_S_GET_CONFIG_LIST;
};

#endif
