/************************************************************************
 * FILE:          clTmcTuner_Method_S_STATIONLIST_EXIT.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_STATIONLIST_EXIT.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  
 *************************************************************************/

#include "clTmcTuner_Method_S_STATIONLIST_EXIT.h"
#include "CcaApp/clCCAhandler.h"
#include "Aars/clAars_CM_StationListRelease.h"
#include "ADRMsg/ADRMsg_if.h"
#include "tun_MsgFromHMI.h"

using namespace tuner::CcaApp;
using namespace Mute;
using namespace Mute::MuteHandling;

#include "tun_trace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Method_S_STATIONLIST_EXIT.cpp.trc.h"
#endif

/*****************************************************************************
* Destructor
******************************************************************************/
clTmcTuner_Method_S_STATIONLIST_EXIT::~clTmcTuner_Method_S_STATIONLIST_EXIT()
{
	m_poclAars_CM_StationListRelease = 0;
	muteImpl = 0;
	m_u8NumberOfFMStationlistExitRequests = 0;
	m_u8NumberOfAMStationlistExitRequests = 0;
	m_e8ConfigListID = midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_INVALID_TYPE;
	m_poclTmcTuner_Method_S_GET_CONFIG_LIST = 0;
}


/*****************************************************************************
* Constructor
******************************************************************************/
clTmcTuner_Method_S_STATIONLIST_EXIT::clTmcTuner_Method_S_STATIONLIST_EXIT(tuner::CcaApp::clCCAhandler* poCCAhandler,
		clAars_CM_StationListRelease* poclAars_CM_StationListRelease\
	,clTmcTuner_Method_S_GET_CONFIG_LIST* poclTmcTuner_Method_S_GET_CONFIG_LIST)
: clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_STATIONLIST_EXIT, poCCAhandler)
{
	m_poclAars_CM_StationListRelease =poclAars_CM_StationListRelease;
	m_poclTmcTuner_Method_S_GET_CONFIG_LIST = poclTmcTuner_Method_S_GET_CONFIG_LIST;
	muteImpl = clMuteImpl::instance();
	m_u8NumberOfFMStationlistExitRequests = 0;
	m_u8NumberOfAMStationlistExitRequests = 0;
	m_e8ConfigListID = midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_INVALID_TYPE;
}


/*****************************************************************************
* vMethodStart
******************************************************************************/
tVoid clTmcTuner_Method_S_STATIONLIST_EXIT::vMethodStart(amt_tclServiceData* poInMessage)
{
	midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodStart oMessage;
	m_poCCAhandler->vGetDataFromAmt(poInMessage, oMessage);

	if(poInMessage->u16GetSourceAppID() != CCA_C_U16_APP_GENERIC_PROXY)
	{
		vIncrementNoOfStationlistExitRequests(oMessage.e8ConfigListID.enType);

		ETG_TRACE_USR4(( "clTmcTuner_Method_S_STATIONLIST_EXIT::vMethodStart() currentaction = %d", muteImpl->getCurrentMuteTuningAction()));
		if(((muteImpl->getCurrentMuteTuningAction() == Mute::MuteHandling::STATIONLIST) || (muteImpl->getNextMuteTuningAction() == Mute::MuteHandling::STATIONLIST) )
			&&
			( m_e8ConfigListID == midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_INVALID_TYPE))
		{
			m_e8ConfigListID = oMessage.e8ConfigListID.enType;
			ETG_TRACE_USR4(( "clTmcTuner_Method_S_STATIONLIST_EXIT::vMethodStart() Stored close request for = %d", (unsigned char)m_e8ConfigListID));

		}
		else
		{
			if(bIsStationListExitRequired(oMessage.e8ConfigListID.enType))
			{
				vSendStationListExit(oMessage.e8ConfigListID.enType);
			}
			vDecrementNoOfStationlistExitRequests(oMessage.e8ConfigListID.enType);
			m_poclTmcTuner_Method_S_GET_CONFIG_LIST->vDecreementOpenStationListsCount(oMessage.e8ConfigListID.enType);

		}
	}
	else
	{
		vSendStationListExit((midw_fi_tcl_e8_Tun_ConfigListID::tenType)0x03);
	}

	midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodResult oResult;
	oResult.TunerServer_StatusResponse.u8TunerStatus.enType=midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED;
	vSendMethodResult(oResult);
}

bool clTmcTuner_Method_S_STATIONLIST_EXIT::bIsStationListExitRequired(midw_fi_tcl_e8_Tun_ConfigListID::tenType e8ListId)
{
	if(m_poclTmcTuner_Method_S_GET_CONFIG_LIST->u8GetOpenStationListsCount(e8ListId) == 1)
	{
		return true;
	}
	else
	{
		return false;
	}
}



bool clTmcTuner_Method_S_STATIONLIST_EXIT::bIsStationListExitRequested(midw_fi_tcl_e8_Tun_ConfigListID::tenType e8ListId)
{
	ETG_TRACE_USR4(( "clTmcTuner_Method_S_STATIONLIST_EXIT::bIsStationListExitRequested m_u8NumberOfFMStationlistExitRequests = %d m_u8NumberOfAMStationlistExitRequests = %d"
		,m_u8NumberOfFMStationlistExitRequests,m_u8NumberOfAMStationlistExitRequests ));

	switch(e8ListId)
	{
	case midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_FM :
		{
			return ((int)m_u8NumberOfFMStationlistExitRequests > 0) ? true: false;
		}
		break;
	case midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_AM :
	case midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_MW :
		{
			return ((int)m_u8NumberOfAMStationlistExitRequests > 0) ? true: false;
		}
		break;
	case midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_TMC :
		{
			//Do Nothing
		}
		break;

	default :
		{
			//Error case do Nothing
		}
		break;
	}
	return false;
}


void clTmcTuner_Method_S_STATIONLIST_EXIT::vClearStationListExitRequested(midw_fi_tcl_e8_Tun_ConfigListID::tenType e8ListId)
{
	ETG_TRACE_USR4(( "clTmcTuner_Method_S_STATIONLIST_EXIT::vClearStationListExitRequested = %d m_u8NumberOfAMStationlistExitRequests = %d"
		,m_u8NumberOfFMStationlistExitRequests,m_u8NumberOfAMStationlistExitRequests ));
	switch(e8ListId)
	{
	case midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_FM :
		{			
			m_u8NumberOfFMStationlistExitRequests = 0;
		}
		break;
	case midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_AM :
	case midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_MW :
		{
			m_u8NumberOfAMStationlistExitRequests = 0;
		}
		break;
	case midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_TMC :
		{
			//Do Nothing
		}
		break;

	default :
		{
			//Error case do Nothing
		}
		break;
	}
	m_e8ConfigListID = midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_INVALID_TYPE;
}

void clTmcTuner_Method_S_STATIONLIST_EXIT::vClearAllStationListExitRequests()
{
	ETG_TRACE_USR4(( "clTmcTuner_Method_S_STATIONLIST_EXIT::vClearAllStationListExitRequests "));
	
	m_u8NumberOfFMStationlistExitRequests = 0;
	m_u8NumberOfAMStationlistExitRequests = 0;
	m_e8ConfigListID = midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_INVALID_TYPE;
}


void clTmcTuner_Method_S_STATIONLIST_EXIT::vSendStationListExit(midw_fi_tcl_e8_Tun_ConfigListID::tenType e8ListId)
{
	m_poclAars_CM_StationListRelease->vReleaseStationList((unsigned char)e8ListId);
}


void clTmcTuner_Method_S_STATIONLIST_EXIT::vIncrementNoOfStationlistExitRequests(midw_fi_tcl_e8_Tun_ConfigListID::tenType e8ListId)
{
	switch(e8ListId)
	{
	case midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_FM :
		{			
			m_u8NumberOfFMStationlistExitRequests++;
		}
		break;
	case midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_AM :
	case midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_MW :
		{
			m_u8NumberOfAMStationlistExitRequests++;
		}
		break;
	case midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_TMC :
		{
			//Do Nothing
		}
		break;

	default :
		{
			//Error case do Nothing
		}
		break;
	}
}

void clTmcTuner_Method_S_STATIONLIST_EXIT::vDecrementNoOfStationlistExitRequests(midw_fi_tcl_e8_Tun_ConfigListID::tenType e8ListId)
{
	switch(e8ListId)
	{
	case midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_FM :
		{			
			m_u8NumberOfFMStationlistExitRequests > 0 ? m_u8NumberOfFMStationlistExitRequests-- : 0 ;
		}
		break;
	case midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_AM :
	case midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_MW :
		{
			m_u8NumberOfAMStationlistExitRequests > 0 ? m_u8NumberOfAMStationlistExitRequests-- : 0 ;
		}
		break;
	case midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_TMC :
		{
			//Do Nothing
		}
		break;

	default :
		{
			//Error case do Nothing
		}
		break;
	}
}


void clTmcTuner_Method_S_STATIONLIST_EXIT::vSetConfigListId(midw_fi_tcl_e8_Tun_ConfigListID::tenType e8ListId)
{
	m_e8ConfigListID = e8ListId;
}
