
/************************************************************************
 * FILE:           clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification

 *************************************************************************/

#ifndef clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST_h
#define clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST_h


#include "CcaApp/clServerMethod.h"
#include "ADRMsg/ADRMsg_if.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "interface/clTmcTuner_HMI_ImpInterface.h"
#ifndef TUN_MsgToADR_H
#include "tun_MsgToADR.h"
#endif
class clAars_ATPresetListSetActive;
class clAars_ATPresetList_XX;
class tun_MsgToHMI;
class clTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID;
class clConfigInterface;
class clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST : public tuner::CcaApp::clServerMethod, public clTmcTuner_HMI_ImpInterface
{
   public:
      virtual ~clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST();
	  virtual void vOnATPresetListSetActiveResult();
      clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST(tuner::CcaApp::clCCAhandler* poCCAhandler, clAars_ATPresetListSetActive* poATPresetListSetActive,
    		  tun_ActualData* potun_ActualData,clAars_ATPresetList_XX* poATPresetList_XX,tun_MsgToHMI* potun_MsgToHMI,clConfigInterface*  poclConfigInterface);
      void vSet_G_GET_ACTIVE_PRESETLISTID_Ptr( clTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID*  poclTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID);
      unsigned short U16GetADR3PresetListIDForSetActivePresetList();
      void vStoreActivePresetList(unsigned short U16ADR3PresetListID);
      bool bIsActivePresetListRequested();
	  void vSetActivePresetListRequested(bool bSetState);
	  void vSaveListIDForSetActivePresetList(unsigned short U16ADR3PresetListID);

   private:
      virtual tVoid vMethodStart(amt_tclServiceData* poInMsg);
	  bool bIsPresetListMatchesCurrentBand(unsigned short U16List);
	  unsigned short m_U16ADR3PresetListIDForSetActivePresetList;
	  bool m_bSetActivePresetListRequested;

      clAars_ATPresetListSetActive* m_poATPresetListSetActive;
      tun_ActualData*	m_potun_ActualData;
      clAars_ATPresetList_XX* m_poATPresetList_XX;
	  tun_MsgToHMI* m_potun_MsgToHMI;
	  clTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID* m_poclTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID;
	  clConfigInterface *m_poclConfigInterface;
};


#endif
