/************************************************************************
 * FILE:           clTmcTuner_Method_S_SEL_HD_AUDIOPRGMDIRECT.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_SEL_HD_AUDIOPRGMDIRECT.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
	
 *************************************************************************/


#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "AMFMTuner/clTmcTuner_Method_S_SEL_HD_AUDIOPRGMDIRECT.h"
#include "CcaApp/clCCAhandler.h"
#include "Aars/clAars_ATHDAudioProgramDirect.h"
#include "kdsconfig/clConfigInterface.h"
using namespace tuner::CcaApp;


#include "tuner_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Method_S_SEL_HD_AUDIOPRGMDIRECT.cpp.trc.h"
#endif



/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Method_S_SEL_HD_AUDIOPRGMDIRECT::~clTmcTuner_Method_S_SEL_HD_AUDIOPRGMDIRECT()
{
   m_poATHDAudioProgramDirect = NULL;
   m_poclConfigInterface = 0;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Method_S_SEL_HD_AUDIOPRGMDIRECT::clTmcTuner_Method_S_SEL_HD_AUDIOPRGMDIRECT(clCCAhandler* poCCAhandler, clAars_ATHDAudioProgramDirect* poATHDAudioProgramDirect,clConfigInterface* poclConfigInterface)
   : clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_SEL_HD_AUDIOPRGMDIRECT, poCCAhandler)
   , m_poATHDAudioProgramDirect(poATHDAudioProgramDirect)
    ,m_poclConfigInterface(poclConfigInterface)
{
}


/**************************************************************************//**
* 
******************************************************************************/
tVoid clTmcTuner_Method_S_SEL_HD_AUDIOPRGMDIRECT::vMethodStart(amt_tclServiceData* poInMessage)
{
   ETG_TRACE_USR4(("clTmcTuner_Method_S_SEL_HD_AUDIOPRGMDIRECT: MethodStart"));
   midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodResult oResult;
   /*Fix for RTC bug 99101 */
   if((m_poclConfigInterface->u32GetConfigData("HDSupported")))
   {
	   midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodStart oMessage;
	   m_poCCAhandler->vGetDataFromAmt(poInMessage, oMessage);
	   m_poATHDAudioProgramDirect->vSelectHDAudioProgramDirect(oMessage.u32Frequency,(tU8)oMessage.e8HDAudioPrg.enType);
   }
   else
   {
	   oResult.TunerServer_StatusResponse.u8TunerStatus.enType=midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL;
	   oResult.TunerServer_StatusResponse.u8TunerState.enType =midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;
   }
   vSendMethodResult(oResult);
}


