/************************************************************************
 * FILE:           clTmcTuner_Method_S_SELECT_HD_AUDIOPRGM.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  clTmcTuner_Method_S_SELECT_HD_AUDIOPRGM method class implementation
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification

 *************************************************************************/

#include "AMFMTuner/clTmcTuner_Method_S_SELECT_HD_AUDIOPRGM.h"
#include "CcaApp/clCCAhandler.h"
#include "Aars/clAars_ATHDAudioProgram.h"

using namespace tuner::CcaApp;


#include "tuner_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Method_S_SELECT_HD_AUDIOPRGM.cpp.trc.h"
#endif



/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Method_S_SELECT_HD_AUDIOPRGM::~clTmcTuner_Method_S_SELECT_HD_AUDIOPRGM()
{
   m_poATHDAudioProgram = NULL;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Method_S_SELECT_HD_AUDIOPRGM::clTmcTuner_Method_S_SELECT_HD_AUDIOPRGM(clCCAhandler* poCCAhandler, clAars_ATHDAudioProgram* poATHDAudioProgram)
   : clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_SELECT_HD_AUDIOPRGM, poCCAhandler)
   , m_poATHDAudioProgram(poATHDAudioProgram)
{
}


/**************************************************************************//**
* 
******************************************************************************/
tVoid clTmcTuner_Method_S_SELECT_HD_AUDIOPRGM::vMethodStart(amt_tclServiceData* poInMessage)
{
   ETG_TRACE_USR4(("clTmcTuner_Method_S_SELECT_HD_AUDIOPRGM: MethodStart"));
   m_poCCAhandler->vGetDataFromAmt(poInMessage, m_oMessage);

   if(bIsSelectModeRelative())
   {
	   if(bIsRelativeModeIncrement())
	   {
		   m_poATHDAudioProgram->vIncrementHDAudioProgram();
	   }
	   else
	   {
		   m_poATHDAudioProgram->vDecrementHDAudioProgram();
	   }
	   
   }
   else 
   {
	   m_poATHDAudioProgram->vSelectHDAudioProgram((tU8)m_oMessage.e8HDAudioPrg.enType);
   }

   midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodResult oResult;
   vSendMethodResult(oResult);
}



/**************************************************************************//**
* 
******************************************************************************/
tBool clTmcTuner_Method_S_SELECT_HD_AUDIOPRGM::bIsSelectModeRelative()
{
	if(m_oMessage.SelectMode.enType == midw_fi_tcl_e8_Tun_SelectMode::FI_EN_TUN_SELECTMODE_RELATIVE)
	{
		return true;
	}
	else
	{
		return false;
	}
}

/**************************************************************************//**
* 
******************************************************************************/
tBool clTmcTuner_Method_S_SELECT_HD_AUDIOPRGM::bIsRelativeModeIncrement()
{
	if(m_oMessage.e8Direction.enType == midw_fi_tcl_e8_Tun_RelativeDirection::FI_EN_TUN_RELATIVE_INCREMENT)
	{
		return true;
	}
	else
	{
		return false;
	}
}
