/************************************************************************
 * FILE:            clTmcTuner_Method_S_SELECT_DRM_AUDIOPRGM.cpp
  * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clTmcTuner_Method_S_SELECT_DRM_AUDIOPRGM.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
	
 *************************************************************************/


#include "AMFMTuner/clTmcTuner_Method_S_SELECT_DRM_AUDIOPRGM.h"
#include "CcaApp/clCCAhandler.h"
#include "tun_ActualData.h"
#include "tun_MsgToADR.h"
#include "Aars/clAars_CM_ATDRM_AudioServiceDirect.h"
using namespace tuner::CcaApp;

/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Method_S_SELECT_DRM_AUDIOPRGM::~clTmcTuner_Method_S_SELECT_DRM_AUDIOPRGM()
{
	m_poclAars_CM_ATDRM_AudioServiceDirect=NULL;
	m_potun_ActualData=NULL;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Method_S_SELECT_DRM_AUDIOPRGM::clTmcTuner_Method_S_SELECT_DRM_AUDIOPRGM(tuner::CcaApp::clCCAhandler* poCCAhandler,tun_ActualData* potun_ActualData, clAars_CM_ATDRM_AudioServiceDirect* poclAars_CM_ATDRM_AudioServiceDirect)
   : clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_SELECT_DRM_AUDIOPRGM, poCCAhandler)
	,m_potun_ActualData(potun_ActualData)
    ,m_poclAars_CM_ATDRM_AudioServiceDirect(poclAars_CM_ATDRM_AudioServiceDirect)
{

}


/**************************************************************************//**
* vMethodStart
******************************************************************************/
tVoid clTmcTuner_Method_S_SELECT_DRM_AUDIOPRGM::vMethodStart(amt_tclServiceData* poInMessage)
{
  midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodStart oMessage;
  m_poCCAhandler->vGetDataFromAmt(poInMessage, oMessage);
  midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodResult oResult;
  oResult.TunerServer_StatusResponse.u8TunerStatus.enType=midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL;
  oResult.TunerServer_StatusResponse.u8TunerState.enType =midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;
  if(m_potun_ActualData->m_otun_Data_Station.u8GetBand()==enBand_CB1)
  {
	m_poclAars_CM_ATDRM_AudioServiceDirect->vSetDRMAudioServiceDirect(oMessage.u32Frequency,oMessage.u32DRMServiceId);
	oResult.TunerServer_StatusResponse.u8TunerStatus.enType=midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED;
  }
  vSendMethodResult(oResult);
}
