/************************************************************************
 * FILE:           clTmcTuner_Method_S_SEEK.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_SEEK.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
	
 *************************************************************************/


#ifndef clTmcTuner_Method_S_SEEK_h
#define clTmcTuner_Method_S_SEEK_h

#include "CcaApp/clServerMethod.h"
#include "ADRMsg/ADRMsg_if.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "interface/clTmcTuner_HMI_ImpInterface.h"
#include "TunerApp/Mute/clMuteInterface.h"

class clAars_ATSeek;

class clSeekMuteData
{
public:
	virtual ~clSeekMuteData() {}
	midw_fi_tcl_e8_Tun_TunerSeek m_oSeekType;
	unsigned int m_u32Frequency;
	clSeekMuteData();
	bool bIsStoredDataValid();
};

class clTmcTuner_Method_S_SEEK : public tuner::CcaApp::clServerMethod, public clTmcTuner_HMI_ImpInterface, public Mute::clMuteInterface
{
public:
    virtual ~clTmcTuner_Method_S_SEEK();
    clTmcTuner_Method_S_SEEK( tuner::CcaApp::clCCAhandler* poCCAhandler, clAars_ATSeek* poATSeek);

private:
    virtual tVoid vMethodStart(amt_tclServiceData* poInMsg);

    clAars_ATSeek* m_poATSeek;
	clSeekMuteData m_oMuteData;
    midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodStart m_oMessage;
    virtual void vProcessTunerAction();
    virtual void vOnNewMuteTunerAction(Mute::MuteHandling::enMuteTuningAction);
    virtual void vOnAudioMuteRequest();
    virtual void vOnDemuteSendMethodResult();
    virtual void vOnTunerStateIdle();
	virtual void vClearStoredRequest();
	void vStoreMuteData(midw_fi_tcl_e8_Tun_TunerSeek oSeekType, unsigned int u32Frequency);
    bool bIsTunScan();
};


#endif
