/************************************************************************
 * FILE:           clTmcTuner_Method_S_PRESET_STORAGE_PS_FREEZE.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_PRESET_STORAGE_PS_FREEZE.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
	
 *************************************************************************/


#include "AMFMTuner/clTmcTuner_Method_S_PRESET_STORAGE_PS_FREEZE.h"
#include "CcaApp/clCCAhandler.h"
#include "Aars/clAars_ATPreparePresetStorage.h"
#include "conversionTable/midwTunerToAdr3Map.h"
using namespace tuner::CcaApp;

/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Method_S_PRESET_STORAGE_PS_FREEZE::~clTmcTuner_Method_S_PRESET_STORAGE_PS_FREEZE()
{
	m_poATPreparePresetStorage = 0;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Method_S_PRESET_STORAGE_PS_FREEZE::clTmcTuner_Method_S_PRESET_STORAGE_PS_FREEZE(tuner::CcaApp::clCCAhandler* poCCAhandler, clAars_ATPreparePresetStorage* poATPreparePresetStorage)
   : clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_PRESET_STORAGE_PS_FREEZE, poCCAhandler)
    ,m_poATPreparePresetStorage(poATPreparePresetStorage)
{

}


/**************************************************************************//**
* vMethodStart
******************************************************************************/
tVoid clTmcTuner_Method_S_PRESET_STORAGE_PS_FREEZE::vMethodStart(amt_tclServiceData* poInMessage)
{
  midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodStart oMessage;
  m_poCCAhandler->vGetDataFromAmt(poInMessage, oMessage);
  midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodResult oResult;
  oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL;
  if((midw_fi_tcl_e8_PS_Freeze_Mode::FI_EN_FREEZE == oMessage.e8Mode.enType) || (midw_fi_tcl_e8_PS_Freeze_Mode::FI_EN_UNFREEZE ==oMessage.e8Mode.enType))
  {
	m_poATPreparePresetStorage->vSendATPreparePresetStorage(oMessage.e8Mode.enType);
  oResult.TunerServer_StatusResponse.u8TunerStatus.enType=midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED;
  }
  vSendMethodResult(oResult);
}
