/************************************************************************
 * FILE:           clTmcTuner_Method_S_PRESET_HANDLING.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_PRESET_HANDLING.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
	
 *************************************************************************/


#include "clTmcTuner_Method_S_PRESET_HANDLING.h"
#include "CcaApp/clCCAhandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "Aars/clAars_ATPresetList_XX.h"
#include "Aars/clAars_ATPresetSave.h"
#include "conversionTable/midwTunerToAdr3Map.h"
#include "TunerApp/Mute/MuteHandling/clMuteImpl.h"

using namespace tuner::CcaApp;
using namespace Mute::MuteHandling;

#include "tun_trace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Method_S_PRESET_HANDLING.cpp.trc.h"
#endif

/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Method_S_PRESET_HANDLING::~clTmcTuner_Method_S_PRESET_HANDLING()
{
	m_poATPresetList_XX=0;
	m_poATPresetSave=0;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Method_S_PRESET_HANDLING::clTmcTuner_Method_S_PRESET_HANDLING(tuner::CcaApp::clCCAhandler* poCCAhandler, clAars_ATPresetList_XX* poATPresetList_XX,
		clAars_ATPresetSave* poATPresetSave)
   : clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_PRESET_HANDLING, poCCAhandler)
    ,m_poATPresetList_XX(poATPresetList_XX)
    ,m_poATPresetSave(poATPresetSave)
{

}


/**************************************************************************//**
* vMethodStart
******************************************************************************/
tVoid clTmcTuner_Method_S_PRESET_HANDLING::vMethodStart(amt_tclServiceData* poInMessage)
{
	midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart oMessage;
	m_poCCAhandler->vGetDataFromAmt(poInMessage, oMessage);
	unsigned short U16ADR3PresetListID = U16GetADR3PresetListID(oMessage.e8ListID.enType);
	midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodResult oResult;
	oResult.e8Action.enType= oMessage.e8Action.enType;
	oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL;
	oResult.TunerServer_StatusResponse.u8TunerState.enType = midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;
	ETG_TRACE_USR4(("clTmcTuner_Method_S_PRESET_HANDLING:: vMethodStart() U16ADR3PresetListID = %d, action = %d, listId = %d", U16ADR3PresetListID, (tU8)oMessage.e8Action.enType, (tU8)oMessage.e8ListID.enType));
	if(enMsg_Unknown_Message_0x0000==U16ADR3PresetListID )
	{
		vSendMethodResult(oResult);
		return;
	}
	oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED;
	switch((tU8) oMessage.e8Action.enType)
	{
	case midw_fi_tcl_e8_Tun_PresetAction::FI_EN_RECALL_ELEMENT:
	{
		vRecallPreset(U16ADR3PresetListID,oMessage.u8ListElementID);
		break;
	}
	case midw_fi_tcl_e8_Tun_PresetAction::FI_EN_SAVE_ELEMENT:
	{
		vPresetSave(U16ADR3PresetListID,oMessage.u8ListElementID);
		break;
	}
	case midw_fi_tcl_e8_Tun_PresetAction::FI_EN_DELETE_ALL_ELEMENTS:
	{
		vDeleteAllPreset(U16ADR3PresetListID);
		break;
	}
	case midw_fi_tcl_e8_Tun_PresetAction::FI_EN_DELETE_ONE_ELEMENT:
	{
		vDeleteSinglePreset(U16ADR3PresetListID,oMessage.u8ListElementID);
		break;
	}
	case midw_fi_tcl_e8_Tun_PresetAction::FI_EN_SPECIAL_SAVE_ELEMENT:
	{
		vPresetSpecialSave(U16ADR3PresetListID,oMessage.u8ListElementID,oMessage.u16PI,oMessage.u32Frequency);
		break;
	}
	default:
	{
		oResult.TunerServer_StatusResponse.u8TunerStatus.enType=midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL;
		break;
	}
	}
	if( ((tU8)oMessage.e8Action.enType) != midw_fi_tcl_e8_Tun_PresetAction::FI_EN_RECALL_ELEMENT)
	{
		vSendMethodResult(oResult);
	}
}

/*****************************************************************************

******************************************************************************/
void clTmcTuner_Method_S_PRESET_HANDLING::vRecallPreset(unsigned short U16ADR3PresetListID,unsigned char u8ListElementID)
{
	vStorePresetData(U16ADR3PresetListID, u8ListElementID);
	vOnNewMuteTunerAction(Mute::MuteHandling::PRESETRECALL);
}

void clTmcTuner_Method_S_PRESET_HANDLING::vOnNewMuteTunerAction(Mute::MuteHandling::enMuteTuningAction muteAction)
{
	ETG_TRACE_USR4(( "clTmcTuner_Method_S_PRESET_HANDLING::vOnNewMuteTunerAction()"));
	clMuteImpl::instance()->vOnNewMuteTunerAction(muteAction);
	ETG_TRACE_USR4(( "clTmcTuner_Method_S_PRESET_HANDLING::vOnNewMuteTunerAction() muteImpl = %p", clMuteImpl::instance()));
}


void clTmcTuner_Method_S_PRESET_HANDLING::vStorePresetData(unsigned short u16PresetListID, unsigned char u8PresetListElementID)
{
	m_oMuteData.m_u16PresetListID = u16PresetListID;
	m_oMuteData.m_u8PresetListElementID = u8PresetListElementID;
}

void clTmcTuner_Method_S_PRESET_HANDLING::vOnAudioMuteRequest()
{

}

void clTmcTuner_Method_S_PRESET_HANDLING::vProcessTunerAction()
{
	if(m_oMuteData.bIsStoredDataValid())
	{
		m_poATPresetList_XX->vSelectPresetListElement(m_oMuteData.m_u16PresetListID, m_oMuteData.m_u8PresetListElementID);
		vClearStoredRequest();
	}
}

bool clPresetRecallMuteData::bIsStoredDataValid()
{
	ETG_TRACE_USR4(( "clPresetRecallMuteData::bIsStoredDataValid() m_u16PresetListID = %d, m_u8PresetListElementID = %d", m_u16PresetListID, m_u8PresetListElementID));
	if(m_u16PresetListID != 0 && m_u8PresetListElementID != 0)
	{
		return true;
	}
	return false;
}
/*****************************************************************************

******************************************************************************/
void clTmcTuner_Method_S_PRESET_HANDLING::vPresetSave(unsigned short U16ADR3PresetListID,unsigned char u8ListElementID)
{
	m_poATPresetSave->vSavePreset(U16ADR3PresetListID,u8ListElementID);
	m_poATPresetList_XX->vGetPresetList(U16ADR3PresetListID);
}
/*****************************************************************************

******************************************************************************/
void clTmcTuner_Method_S_PRESET_HANDLING::vDeleteSinglePreset(unsigned short U16ADR3PresetListID,unsigned char u8ListElementID)
{
	m_poATPresetList_XX->vDeleteSinglePresetElement(U16ADR3PresetListID,u8ListElementID);
	//Since preset delete does not have status response, Send a request to get the whole preset list
	m_poATPresetList_XX->vGetPresetList(U16ADR3PresetListID);

}
/*****************************************************************************

******************************************************************************/
void clTmcTuner_Method_S_PRESET_HANDLING::vDeleteAllPreset(unsigned short U16ADR3PresetListID)
{
	m_poATPresetList_XX->vDeleteAllPreset(U16ADR3PresetListID);
	//Since preset delete does not have status response, Send a request to get the whole preset list
	m_poATPresetList_XX->vGetPresetList(U16ADR3PresetListID);
}
/*****************************************************************************

******************************************************************************/
void clTmcTuner_Method_S_PRESET_HANDLING::vPresetSpecialSave(unsigned short U16ADR3PresetListID,unsigned char u8ListElementID,unsigned short u16PI, unsigned int u32Frequency)
{
	m_poATPresetList_XX->vSendSpecialSaveListElement(U16ADR3PresetListID,u8ListElementID,u16PI,u32Frequency);
}

void clTmcTuner_Method_S_PRESET_HANDLING::vOnDemuteSendMethodResult()
{
	midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodResult oResult;

	oResult.e8Action.enType= midw_fi_tcl_e8_Tun_PresetAction::FI_EN_RECALL_ELEMENT;
	oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED;
	oResult.TunerServer_StatusResponse.u8TunerState.enType = midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;

	vSendMethodResult(oResult);
}

void clTmcTuner_Method_S_PRESET_HANDLING::vOnTunerStateIdle() 
{
}

clPresetRecallMuteData::clPresetRecallMuteData() : m_u16PresetListID(0), m_u8PresetListElementID(0)
{
}

void clTmcTuner_Method_S_PRESET_HANDLING::vClearStoredRequest()
{
	ETG_TRACE_USR4(( "clTmcTuner_Method_S_PRESET_HANDLING::vClearStoredRequest()"));
	m_oMuteData.m_u16PresetListID = 0;
	m_oMuteData.m_u8PresetListElementID = 0;
}

tVoid clTmcTuner_Method_S_PRESET_HANDLING::vConstructSelfPostMessage(unsigned char* puchData)
{
    midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart oMsg;
    tU32 u32Frequency = 0x00;
    tU16 u16PI = 0x00;
	tU16 u16SecondaryPI = 0x00;

	oMsg.e8Action.enType= (midw_fi_tcl_e8_Tun_PresetAction::tenType)puchData[4];
	oMsg.u8ListElementID= puchData[5];
	oMsg.e8ListID.enType = (midw_fi_tcl_e8_Tun_ListID::tenType)puchData[6];

	u32Frequency  = ( tU32 ) ( ( (tU32)  puchData[7]  ) << 24 ) ;
	u32Frequency |= ( tU32 ) ( ( (tU32)  puchData[8]  ) << 16 ) ;
	u32Frequency |= ( tU32 ) ( ( (tU32)  puchData[9]  ) << 8  ) ;
	u32Frequency |= ( tU32 ) (   (tU32)  puchData[10]  );
		
	u16PI = ( tU16 )(u16PI |(( tU16 ) ( ( (tU16)  puchData[11]  ) << 8  ) ));
	u16PI = ( tU16 )(u16PI |(  (tU16)  puchData[12]  ));

	u16SecondaryPI = u16SecondaryPI |(( tU16 ) ( ( (tU16)  puchData[13]  ) << 8  ) );
	u16SecondaryPI = ( tU16 )(u16SecondaryPI |( (tU16)  puchData[14]  ));
	    
    oMsg.u16PI = u16PI;
	oMsg.u16SecondaryPI = u16PI;
    oMsg.u32Frequency = u32Frequency;

    vSendMessage(CCA_C_U16_APP_TUNER, oMsg, MIDW_TUNERFI_C_U16_FID_TUN_S_PRESET_HANDLING, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, 0, 0);
}