/************************************************************************
 * FILE:           clTmcTuner_Method_S_LANGUAGE_SETTING.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_LANGUAGE_SETTING.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
	Jul 21, 2017 		pmn3kor
 *************************************************************************/


#include "AMFMTuner/clTmcTuner_Method_S_LANGUAGE_SETTING.h"
#include "CcaApp/clCCAhandler.h"
#include "tun_MsgToHMI.h"
#include "tun_MsgFromHMI.h"
#include "tun_defines.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "conversionTable/midwTunerToAdr3Map.h"

#include "tuner_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Method_S_LANGUAGE_SETTING.cpp.trc.h"
#endif


using namespace tuner::CcaApp;

/******************************************************************************
*
******************************************************************************/
clTmcTuner_Method_S_LANGUAGE_SETTING::~clTmcTuner_Method_S_LANGUAGE_SETTING()
{
	 m_poclJapanStationName = NULL;
	 m_LanguageSetting = 0; // Default lang is ENGLISH
	 m_poclAars_ATPresetList_XX = NULL;
}

/******************************************************************************
*
******************************************************************************/
clTmcTuner_Method_S_LANGUAGE_SETTING::clTmcTuner_Method_S_LANGUAGE_SETTING(
      tuner::CcaApp::clCCAhandler* poCCAhandler, clJapanStationName *poclJapanStationName,clAars_ATPresetList_XX* poclAars_ATPresetList_XX)
:clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_LANGUAGE_SETTING,  poCCAhandler),m_poclAars_ATPresetList_XX(poclAars_ATPresetList_XX)
{
	m_poclJapanStationName = poclJapanStationName;
	m_LanguageSetting = 0; // Default lang is ENGLISH
}

/******************************************************************************
*
******************************************************************************/
void clTmcTuner_Method_S_LANGUAGE_SETTING::vMethodStart(amt_tclServiceData* poInMsg)
{
   ETG_TRACE_USR4(("clTmcTuner_Method_S_LANGUAGE_SETTING: MethodStart"));
   if(((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToADR==NULL || m_poclJapanStationName==NULL || m_poclAars_ATPresetList_XX == NULL || ((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToHMI == NULL)
   {
	   NORMAL_M_ASSERT(((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToADR!=NULL);
      NORMAL_M_ASSERT(((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToHMI!= NULL);
	   NORMAL_M_ASSERT(m_poclJapanStationName!=NULL);
	   NORMAL_M_ASSERT(m_poclAars_ATPresetList_XX!=NULL);
	   return;
   }

   m_poCCAhandler->vGetDataFromAmt(poInMsg, m_oMessage);
   ETG_TRACE_USR4(("e8Language = %d", m_oMessage.e8Language.enType));

   if( m_oMessage.e8Language.enType > midw_fi_tcl_e8_Tun_Language::FI_EN_LANG_JAPANESE)
   {
	   ETG_TRACE_USR4(("clTmcTuner_Method_S_LANGUAGE_SETTING: Parameter out of range"));
	   vPostMethodResult(midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL);
	   return;
   }
   if(u8GetLanguageSetting() != m_oMessage.e8Language.enType)
   {
	   vSetLanguageSetting(m_oMessage.e8Language.enType);
	   //post new station info (station name changed)
	   ((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToADR->vSendGetAtStationInfo();
	   //for SDS command : inform registered clients that station list update is available (when language is changed, new station names should be packed for station list.
		//so fake that there is a new list update so that new names can be posted to clients using CM_StationListConfig request.)
		clTmcTuner_TMCTunerControl oTunerControl;
		oTunerControl.vOnCM_ChangeOfSurveilledStationsStatus();
		 // update the preset list
		m_poclAars_ATPresetList_XX->vGetPresetList(U16GetADR3PresetListID((midw_fi_tcl_e8_Tun_TunerBand::tenType)((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToHMI->m_u8PrevBand));
   }
   vPostMethodResult(midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED);
 }

/******************************************************************************
*
******************************************************************************/
void clTmcTuner_Method_S_LANGUAGE_SETTING::vPostMethodResult(midw_fi_tcl_e8_Tun_ResponseStatus::tenType newValue)
{
   midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodResult oResult;
   oResult.TunerServer_StatusResponse.u8TunerStatus.enType =  newValue;
   oResult.TunerServer_StatusResponse.u8TunerState.enType = midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;
   vSendMethodResult(oResult);
}
/******************************************************************************
*
******************************************************************************/
unsigned char clTmcTuner_Method_S_LANGUAGE_SETTING::u8GetLanguageSetting()
{
	ETG_TRACE_USR4(("clTmcTuner_Method_S_LANGUAGE_SETTING: u8GetLanguageSetting m_LanguageSetting=0x%02x", m_LanguageSetting));
	return m_LanguageSetting;
}
/******************************************************************************
*
******************************************************************************/

void clTmcTuner_Method_S_LANGUAGE_SETTING::vSetLanguageSetting(unsigned char u8LanguageType)
{
	m_LanguageSetting = u8LanguageType;
	m_poclJapanStationName->vSetSelectedLanguage(m_LanguageSetting);
	ETG_TRACE_USR4(("clTmcTuner_Method_S_LANGUAGE_SETTING: vSetLanguageSetting  m_LanguageSetting = 0x%02x", m_LanguageSetting));
}
