/************************************************************************
 * FILE:           clTmcTuner_Method_S_JAPAN_SET_AREA.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_JAPAN_SET_AREA.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
	Mar 30, 2016 		pmn3kor	
 *************************************************************************/


#ifndef COMPONENTS_FC_TMCTUNER_AMFMTUNER_CLTMCTUNER_METHOD_S_JAPAN_SET_AREA_H_
#define COMPONENTS_FC_TMCTUNER_AMFMTUNER_CLTMCTUNER_METHOD_S_JAPAN_SET_AREA_H_

#include "CcaApp/clServerMethod.h"
//#include "ADRMsg/ADRMsg_if.h"
#include "TunerApp/StationNameJapan/clJapanStationName.h"
#include "tun_Class_ForwardDecl.h"
#include "Aars/clAars_ATPresetList_XX.h"
#include "AMFMTuner/clTmcTuner_Property_G_JAPAN_AREA.h"
#include "AMFMTuner/clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST.h"

#ifndef VARIANT_S_FTR_ENABLE_AIL_MOCK
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif

#ifndef VARIANT_S_FTR_ENABLE_AHL_MOCK
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#else
#include "ahl_mock/ahl_if.h"         // use Application Help Library
#endif


#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"
#else
#include "amt_mock/amt_if.h"
#endif

#ifndef VARIANT_S_FTR_ENABLE_DP_CLIENT_MOCK
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_tuner_if.h"
#include "dp_generic_if.h"
#else
   #include"diaglib_if.h"
#endif

/*----------------------------------------------------------------------*/
/* FI type inclusion                                                    */
/*----------------------------------------------------------------------*/
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h"
/*----------------------------------------------------------------------*/
class clConfigInterface;

class clTmcTuner_Method_S_JAPAN_SET_AREA : public tuner::CcaApp::clServerMethod
{
public:
    virtual ~clTmcTuner_Method_S_JAPAN_SET_AREA();
    clTmcTuner_Method_S_JAPAN_SET_AREA( tuner::CcaApp::clCCAhandler* poCCAhandler, clJapanStationName *poclJapanStationName, clTmcTuner_Property_G_JAPAN_AREA *poclTmcTuner_Property_G_JAPAN_AREA, clConfigInterface* poclConfigInterface, clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST *poclTmcTuner_Property_G_JAPAN_STATION_NAME_LIST,clAars_ATPresetList_XX *poclAars_ATPresetList_XX);
    const char* vGetStationNameFromDatabase();
    const char* sGetStationNameFromDBForListUpdate(unsigned int u32Frequency);
    void vSetJapanAreaCode(unsigned char u8AreaCode);
    unsigned char u8GetJapanAreaCode();
    void vSetJapanSelectedMode(bool bSelectionMode);
    bool bGetJapanSelectedMode();
    unsigned int vGetStationFrequency();
    unsigned char u8GetJapanStationCount();
    unsigned char u8GetPreviousJapanAreaCode();
    void vSetPreviousJapanAreaCode(unsigned char u8NewVal);
    void vConnectDatabaseForJapanStationName();
    void vDisconnectDatabaseForJapanStationName();
    bool bIsJapanRegion();
    bool bIsSuppressStationName();
    void vReadKDSJapanBytes();
    void vSetNewAreaCodeFlag(bool bNewValue);
    bool bGetNewAreaCodeFlag();
    void vSetDefaultSettingRequested(bool bNewValue);
    bool bGetDefaultSettingRequested();
    void vGetDefaultJapanDatabase();
    clJapanStationName *m_poclJapanStationName;

private:
    virtual void vMethodStart(amt_tclServiceData* poInMsg);
    void vHandleJapanStatioNameRequest();
    void vPostMethodResult(midw_fi_tcl_e8_Tun_ResponseStatus::tenType newValue);
    bool bIsRequestFromManualSelectionMode();


    midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodStart m_oMessage;
    clTmcTuner_Property_G_JAPAN_AREA *m_poclTmcTuner_Property_G_JAPAN_AREA;
    clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST *m_poclTmcTuner_Property_G_JAPAN_STATION_NAME_LIST;
    clAars_ATPresetList_XX* m_poclAars_ATPresetList_XX;
    unsigned char m_u8PreviousJapanAreaCode;
    unsigned int m_u32Frequency;
    dp_tclTmcTunerDPManualJapanAreaCode m_ManualJapanAreaCode;
    dp_tclTmcTunerDPAutomaticJapanAreaCode m_AutomaticJapanAreaCode;
    dp_tclTmcTunerDPJapanSelectionMode m_JapanSelectedMode;
    clConfigInterface* m_poclConfigInterface;
    bool bNewAreaCode;
    bool bDefaultSettingForJapanStationName;
};




#endif /* COMPONENTS_FC_TMCTUNER_AMFMTUNER_CLTMCTUNER_METHOD_S_JAPAN_SET_AREA_H_ */
