/************************************************************************
 * FILE:           clTmcTuner_Method_S_JAPAN_SET_AREA.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_JAPAN_SET_AREA.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
	Mar 30, 2016 		pmn3kor	
 *************************************************************************/
 

#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"
#else
#include "amt_mock/amt_if.h"
#endif

#include "AMFMTuner/clTmcTuner_Method_S_JAPAN_SET_AREA.h"
#include "CcaApp/clCCAhandler.h"
#include "tun_MsgToHMI.h"
#include "tun_MsgFromHMI.h"
#include "tun_Utility.h"
#include "kdsconfig/clConfigInterface.h"
#include "tun_defines.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "conversionTable/midwTunerToAdr3Map.h"

#include "tuner_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Method_S_JAPAN_SET_AREA.cpp.trc.h"
#endif


using namespace tuner::CcaApp;

/******************************************************************************
*
******************************************************************************/
clTmcTuner_Method_S_JAPAN_SET_AREA::~clTmcTuner_Method_S_JAPAN_SET_AREA()
{
   m_poclJapanStationName = NULL;
   vSetNewAreaCodeFlag(false);
   vSetPreviousJapanAreaCode(0);
   m_poclTmcTuner_Property_G_JAPAN_AREA = NULL;
	m_poclTmcTuner_Property_G_JAPAN_STATION_NAME_LIST= NULL;	
	m_u32Frequency = 0;
   m_poclConfigInterface = NULL;	
   vSetDefaultSettingRequested( false );
   m_poclAars_ATPresetList_XX = NULL;
}

/******************************************************************************
*
******************************************************************************/
clTmcTuner_Method_S_JAPAN_SET_AREA::clTmcTuner_Method_S_JAPAN_SET_AREA(
      tuner::CcaApp::clCCAhandler* poCCAhandler, clJapanStationName *poclJapanStationName,
      clTmcTuner_Property_G_JAPAN_AREA *poclTmcTuner_Property_G_JAPAN_AREA, clConfigInterface* poclConfigInterface,
		clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST *poclTmcTuner_Property_G_JAPAN_STATION_NAME_LIST,clAars_ATPresetList_XX *poclAars_ATPresetList_XX)
:clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_JAPAN_SET_AREA,  poCCAhandler)
, m_poclJapanStationName(poclJapanStationName)
, m_poclTmcTuner_Property_G_JAPAN_AREA(poclTmcTuner_Property_G_JAPAN_AREA)
, m_poclTmcTuner_Property_G_JAPAN_STATION_NAME_LIST(poclTmcTuner_Property_G_JAPAN_STATION_NAME_LIST)
,m_poclAars_ATPresetList_XX(poclAars_ATPresetList_XX)
, m_u32Frequency(0)
{
	//during start-up the cm_atstationinfo message should read the data from datapool/KDS in msgtohmi file. so set to true
   vSetNewAreaCodeFlag( true );
   vSetPreviousJapanAreaCode(u8GetJapanAreaCode());
   m_poclConfigInterface = poclConfigInterface;
   vSetDefaultSettingRequested( false );
}

/******************************************************************************
*
******************************************************************************/
void clTmcTuner_Method_S_JAPAN_SET_AREA::vMethodStart(amt_tclServiceData* poInMsg)
{
   ETG_TRACE_USR4(("clTmcTuner_Method_S_JAPAN_SET_AREA: MethodStart"));

   if(m_poclJapanStationName==NULL || m_poclTmcTuner_Property_G_JAPAN_AREA==NULL
   		|| m_poclTmcTuner_Property_G_JAPAN_STATION_NAME_LIST==NULL || m_poclConfigInterface==NULL ||
			((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToADR==NULL || ((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToHMI==NULL  || (m_poclAars_ATPresetList_XX == NULL))
   {
		 NORMAL_M_ASSERT(m_poclJapanStationName != NULL);
		 NORMAL_M_ASSERT(m_poclTmcTuner_Property_G_JAPAN_AREA != NULL);
		 NORMAL_M_ASSERT(m_poclTmcTuner_Property_G_JAPAN_STATION_NAME_LIST != NULL);
		 NORMAL_M_ASSERT(m_poclConfigInterface != NULL);
		 NORMAL_M_ASSERT(((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToADR != NULL);
		 NORMAL_M_ASSERT(((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToHMI != NULL);
		 NORMAL_M_ASSERT(m_poclAars_ATPresetList_XX != NULL);
		 return;
   }

   m_poCCAhandler->vGetDataFromAmt(poInMsg, m_oMessage);
   ETG_TRACE_USR4(("e8SelectedRegion = %d, bAreaSelectionMode = %d", m_oMessage.e8SelectedRegion.enType, m_oMessage.bAreaSelectionMode));

   if((m_oMessage.e8SelectedRegion.enType < midw_fi_tcl_e8_Tun_Japan_Region::FI_EN_TUN_HOKKAIDO) ||
	   ((m_oMessage.e8SelectedRegion.enType > midw_fi_tcl_e8_Tun_Japan_Region::FI_EN_TUN_KYUSHU ) && (m_oMessage.e8SelectedRegion.enType != midw_fi_tcl_e8_Tun_Japan_Region::FI_EN_TUN_AUTO)))
   {
	   ETG_TRACE_USR4(("clTmcTuner_Method_S_JAPAN_SET_AREA: Parameter out of range"));
	   vPostMethodResult(midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL);
	   return;
   }
   //set this flag to true so that database can be queried while posting station info for area code change
   vSetNewAreaCodeFlag( true );

   vHandleJapanStatioNameRequest();
   //if(requested selection mode is automatic(from navi) and currently datapool selection mode is manual then do not get station info. just save area code and exit
   if(!( (m_oMessage.bAreaSelectionMode == AUTOMATIC_UPDATE) && (bGetJapanSelectedMode() == MANUAL_UPDATE ) ) )
   {
   		//these property updates are not posted when selection mode is manual and Set area request is received from Navi. Area value will be saved and update when auto mode is set
	   ((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToADR->vSendGetAtStationInfo();
	   //for SDS command : inform registered clients that station list update is available (when area code is changed, new station names should be packed for station list.
	   //so fake that there is a new list update so that new names can be posted to clients using CM_StationListConfig request.
	   clTmcTuner_TMCTunerControl oTunerControl;
	   oTunerControl.vOnCM_ChangeOfSurveilledStationsStatus();
	   m_poclTmcTuner_Property_G_JAPAN_AREA->vSendStatusToClient();
	   m_poclTmcTuner_Property_G_JAPAN_STATION_NAME_LIST->vSendStatusToClient();
	   // update the preset list
	   m_poclAars_ATPresetList_XX->vGetPresetList(U16GetADR3PresetListID((midw_fi_tcl_e8_Tun_TunerBand::tenType)((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToHMI->m_u8PrevBand));

   }
   vPostMethodResult(midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED);
 }

/******************************************************************************
*
******************************************************************************/
void clTmcTuner_Method_S_JAPAN_SET_AREA::vPostMethodResult(midw_fi_tcl_e8_Tun_ResponseStatus::tenType newValue)
{
   midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodResult oResult;
   oResult.TunerServer_StatusResponse.u8TunerStatus.enType =  newValue;
   oResult.TunerServer_StatusResponse.u8TunerState.enType = midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;
   vSendMethodResult(oResult);
}

/******************************************************************************
*
******************************************************************************/
void clTmcTuner_Method_S_JAPAN_SET_AREA::vHandleJapanStatioNameRequest()
{
   if(m_oMessage.e8SelectedRegion.enType == midw_fi_tcl_e8_Tun_Japan_Region::FI_EN_TUN_AUTO)
   {
      ETG_TRACE_USR4(("clTmcTuner_Method_S_JAPAN_SET_AREA: Auto region is selected from HMI. So Mode will be automatic and region code will be considered from Navi update"));
      vSetJapanSelectedMode(AUTOMATIC_UPDATE);
      //do not set HMI region code to 255(AUTO) as it has to maintain previous value. From now on consider requests from Navi.
   }
   else
   {
      vSetJapanAreaCode(m_oMessage.e8SelectedRegion.enType);
      if(bIsRequestFromManualSelectionMode())
      {
         vSetJapanSelectedMode(MANUAL_UPDATE);
      }
      else
      {
         //no request will be processed from Navi when HMI is not in AUTO mode and Navi request is received. Till then just update the Navi area code which can be used later
         ETG_TRACE_USR4(("clTmcTuner_Method_S_JAPAN_SET_AREA: Automatic update"));
      }
   }
}


/******************************************************************************
*
******************************************************************************/
bool clTmcTuner_Method_S_JAPAN_SET_AREA::bIsRequestFromManualSelectionMode()
{
   if(m_oMessage.bAreaSelectionMode == MANUAL_UPDATE)
      return true;
   else
      return false;
}

/******************************************************************************
*
******************************************************************************/
unsigned int clTmcTuner_Method_S_JAPAN_SET_AREA::vGetStationFrequency()
{
   return (((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToHMI->m_u32ATStationFreq);
}

/******************************************************************************
*
******************************************************************************/
const char* clTmcTuner_Method_S_JAPAN_SET_AREA::vGetStationNameFromDatabase()
{
   //if station name is not available only station freq is shown (psname will be empty)
   //if more than one station name available take only one for which user select is set
   return m_poclJapanStationName->sGetStationNameFromDB();
}


/******************************************************************************
*
******************************************************************************/
const char* clTmcTuner_Method_S_JAPAN_SET_AREA::sGetStationNameFromDBForListUpdate(unsigned int u32frequency)
{
	//if station name is not available only station freq is shown (psname will be empty)
	//if more than one station name available take only one for which user select is set. retrieve station name for all the frequencies of station list
	return m_poclJapanStationName->sGetStationNameForUpdList(u32frequency, u8GetJapanAreaCode());
}

/******************************************************************************
*
******************************************************************************/
unsigned char clTmcTuner_Method_S_JAPAN_SET_AREA::u8GetJapanAreaCode()
{
   if(bGetJapanSelectedMode() == MANUAL_UPDATE)
   {
      ETG_TRACE_USR4(("clTmcTuner_Method_S_JAPAN_SET_AREA: u8GetJapanAreaCode m_ManualJapanAreaCode = %d", m_ManualJapanAreaCode.tGetData()));
      return m_ManualJapanAreaCode.tGetData();
   }
   else // Automatic_update  Navi area code
   {
      ETG_TRACE_USR4(("clTmcTuner_Method_S_JAPAN_SET_AREA: u8GetJapanAreaCode m_AutomaticJapanAreaCode = %d", m_AutomaticJapanAreaCode.tGetData()));
      return m_AutomaticJapanAreaCode.tGetData();
   }
}


/******************************************************************************
*
******************************************************************************/
void clTmcTuner_Method_S_JAPAN_SET_AREA::vSetJapanAreaCode(unsigned char u8AreaCode)
{
   vSetPreviousJapanAreaCode(u8GetJapanAreaCode());
   //check if the current request is from Navi Automatic update or from HMI manual update
   if(m_oMessage.bAreaSelectionMode == MANUAL_UPDATE)
   {
      m_ManualJapanAreaCode.vSetData( u8AreaCode );
      ETG_TRACE_USR4(("clTmcTuner_Method_S_JAPAN_SET_AREA: vSetJapanAreaCode  PreviousJapanAreaCode = %d CurrentJapanAreaCode = %d",
            u8GetPreviousJapanAreaCode(), u8GetJapanAreaCode()));
   }
   else
   {
      m_AutomaticJapanAreaCode.vSetData( u8AreaCode );
      ETG_TRACE_USR4(("clTmcTuner_Method_S_JAPAN_SET_AREA: vSetJapanAreaCode  PreviousJapanAreaCode = %d CurrentJapanAreaCode = %d",
            u8GetPreviousJapanAreaCode(), u8GetJapanAreaCode()));
   }
}

/******************************************************************************
*
******************************************************************************/
bool clTmcTuner_Method_S_JAPAN_SET_AREA::bGetJapanSelectedMode()
{
   ETG_TRACE_USR4(("clTmcTuner_Method_S_JAPAN_SET_AREA: bGetJapanSelectedMode %d", m_JapanSelectedMode.tGetData()));
   return m_JapanSelectedMode.tGetData();
}

/******************************************************************************
*
******************************************************************************/
void clTmcTuner_Method_S_JAPAN_SET_AREA::vSetJapanSelectedMode(bool bSelectionMode)
{
   m_JapanSelectedMode.vSetData( bSelectionMode );
   ETG_TRACE_USR4(("clTmcTuner_Method_S_JAPAN_SET_AREA: vSetJapanSelectedMode  m_JapanSelectedMode = %d", bGetJapanSelectedMode()));
}

/******************************************************************************
*
******************************************************************************/
unsigned char clTmcTuner_Method_S_JAPAN_SET_AREA::u8GetJapanStationCount()
{
	return m_poclJapanStationName->GetJapanStationCount(u8GetJapanAreaCode(), vGetStationFrequency());
}

/******************************************************************************
*
******************************************************************************/
unsigned char clTmcTuner_Method_S_JAPAN_SET_AREA::u8GetPreviousJapanAreaCode()
{
   return m_u8PreviousJapanAreaCode;
}

/******************************************************************************
*
******************************************************************************/
void clTmcTuner_Method_S_JAPAN_SET_AREA::vSetPreviousJapanAreaCode(unsigned char u8AreaCode)
{
   m_u8PreviousJapanAreaCode = u8AreaCode;
}

/******************************************************************************
*
******************************************************************************/
void clTmcTuner_Method_S_JAPAN_SET_AREA::vConnectDatabaseForJapanStationName()
{
   m_poclJapanStationName->vOpenDatabase();
   //check whether to consider area code and mode value from KDS or from datapool
   vReadKDSJapanBytes();
}

/******************************************************************************
*
******************************************************************************/
void clTmcTuner_Method_S_JAPAN_SET_AREA::vDisconnectDatabaseForJapanStationName()
{
   m_poclJapanStationName->vCloseDatabase();
}

/******************************************************************************
*
******************************************************************************/
bool clTmcTuner_Method_S_JAPAN_SET_AREA::bIsJapanRegion()
{
	if(m_poclConfigInterface!=NULL)
	{
	   if(m_poclConfigInterface->u32GetConfigData("Destination_Region") == JAPAN_REGION)
	      return true;
	   else
	      return false;
	}
	NORMAL_M_ASSERT(m_poclConfigInterface != NULL);
	return false;
}

/******************************************************************************
*
******************************************************************************/
bool clTmcTuner_Method_S_JAPAN_SET_AREA::bIsSuppressStationName()
{
	if(m_poclConfigInterface!=NULL)
	{
		if(m_poclConfigInterface->u32GetConfigData("JapaneseStationNamesFromLookupTable") == SUPPRESS_STATION_NAME)
				return true;
			else
				return false;
	}
	NORMAL_M_ASSERT(m_poclConfigInterface != NULL);
	return false;
}
/******************************************************************************
*
******************************************************************************/
bool clTmcTuner_Method_S_JAPAN_SET_AREA::bGetDefaultSettingRequested()
{
	return bDefaultSettingForJapanStationName;
}

/******************************************************************************
*
******************************************************************************/
void clTmcTuner_Method_S_JAPAN_SET_AREA::vSetDefaultSettingRequested(bool bNewValue)
{
	bDefaultSettingForJapanStationName = bNewValue;
}

/******************************************************************************
*
******************************************************************************/
void clTmcTuner_Method_S_JAPAN_SET_AREA::vReadKDSJapanBytes()
{
   /*if japan kds bytes are flashed for the first time datapool value will be 0xfe and it has to be initialized with the KDS values.
    * And for rest all KDS updates, no need to read from it. Only during first flash variable initialization */
   if((m_ManualJapanAreaCode.tGetData() == JAPAN_AREACODE_READ_FROM_KDS) ||
		   (m_AutomaticJapanAreaCode.tGetData() == JAPAN_AREACODE_READ_FROM_KDS) ||  (bGetDefaultSettingRequested()))
   {
      ETG_TRACE_USR4(("\n*************************************************************************\n"
            "Japan Bytes are to be read from KDS entry........... Before reading KDS values.......\n"
    		  "*************************************************************************************\n"
			  "m_ManualJapanAreaCode = %d  m_AutomaticJapanAreaCode = %d  m_JapanSelectedMode= %d\n"
			  "*************************************************************************************",m_ManualJapanAreaCode.tGetData(),
			  m_AutomaticJapanAreaCode.tGetData(), m_JapanSelectedMode.tGetData()));

      //consider selection mode from KDS
      vSetJapanSelectedMode((unsigned char)m_poclConfigInterface->u32GetConfigData("DefaultAreaSelection"));
      //consider both the area codes from KDS entry
      m_ManualJapanAreaCode.vSetData( (unsigned char)m_poclConfigInterface->u32GetConfigData("JapanDefaultArea") );
      m_AutomaticJapanAreaCode.vSetData( (unsigned char)m_poclConfigInterface->u32GetConfigData("JapanDefaultArea") );

      ETG_TRACE_USR4(("\n*************************************************************************\n"
                  "Japan Bytes are initialized from KDS........... After reading KDS values.......\n"
          		  "*************************************************************************************\n"
      			  "m_ManualJapanAreaCode = %d  m_AutomaticJapanAreaCode = %d  m_JapanSelectedMode= %d\n"
      			  "*******************************************************************************", m_ManualJapanAreaCode.tGetData(),
				  m_AutomaticJapanAreaCode.tGetData(), m_JapanSelectedMode.tGetData()));
   }
   else
   {
      ETG_TRACE_USR4(("\n*************************************************************************\n"
            "Japan Bytes are read from datapool entries.... Values are: \n"
            "*************************************************************************************\n"
            "m_ManualJapanAreaCode = %d  m_AutomaticJapanAreaCode = %d  m_JapanSelectedMode= %d\n"
            "*************************************************************************************",m_ManualJapanAreaCode.tGetData(),
			m_AutomaticJapanAreaCode.tGetData(), m_JapanSelectedMode.tGetData()));
   }

   m_poclTmcTuner_Property_G_JAPAN_AREA->vSendStatusToClient();

}

/******************************************************************************
*
******************************************************************************/
void clTmcTuner_Method_S_JAPAN_SET_AREA::vSetNewAreaCodeFlag(bool bNewValue)
{
	bNewAreaCode = bNewValue;
}

/******************************************************************************
*
******************************************************************************/
bool clTmcTuner_Method_S_JAPAN_SET_AREA::bGetNewAreaCodeFlag()
{
	return bNewAreaCode;
}

/******************************************************************************
*
******************************************************************************/
void clTmcTuner_Method_S_JAPAN_SET_AREA::vGetDefaultJapanDatabase()
{
	m_poclJapanStationName->vChangeToDefaultJapanDatabase();
}
