/************************************************************************
 * FILE:           clTmcTuner_Method_S_JAPAN_SELECT_STATION_NAME.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_S_JAPAN_SELECT_STATION_NAME.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
	24/08/2018	 | pmn3kor					  | Initial version of the file
 *************************************************************************/

#include "AMFMTuner/clTmcTuner_Method_S_JAPAN_SELECT_STATION_NAME.h"
#include "AMFMTuner/clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST.h"
#include "CcaApp/clCCAhandler.h"
#include "tun_MsgFromHMI.h"
#include "tun_MsgToHMI.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "tun_defines.h"
#include "conversionTable/midwTunerToAdr3Map.h"
#include "tuner_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Method_S_JAPAN_SELECT_STATION_NAME.cpp.trc.h"
#endif

#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"
#else
#include "amt_mock/amt_if.h"
#endif


OSAL_tTimerHandle  clTmcTuner_Method_S_JAPAN_SELECT_STATION_NAME::m_hNotificationAfter10sec_Timer = 0;

using namespace tuner::CcaApp;

/******************************************************************************
*
******************************************************************************/
clTmcTuner_Method_S_JAPAN_SELECT_STATION_NAME::~clTmcTuner_Method_S_JAPAN_SELECT_STATION_NAME()
{
	m_poclJapanStationName = NULL;
	m_poclTmcTuner_Property_G_JAPAN_STATION_NAME_LIST = NULL;
	if(OSAL_C_INVALID_HANDLE != m_hNotificationAfter10sec_Timer)
	{
		(void)OSAL_s32TimerDelete(m_hNotificationAfter10sec_Timer);
		m_hNotificationAfter10sec_Timer=OSAL_C_INVALID_HANDLE;
	}
	 m_poclAars_ATPresetList_XX = NULL;
}


/******************************************************************************
*
******************************************************************************/
clTmcTuner_Method_S_JAPAN_SELECT_STATION_NAME::clTmcTuner_Method_S_JAPAN_SELECT_STATION_NAME(
      tuner::CcaApp::clCCAhandler* poCCAhandler, clJapanStationName *poclJapanStationName, clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST *poclTmcTuner_Property_G_JAPAN_STATION_NAME_LIST,clAars_ATPresetList_XX* poclAars_ATPresetList_XX)
:clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_JAPAN_SELECT_STATION_NAME, poCCAhandler)
, m_poclJapanStationName(poclJapanStationName)
, m_poclTmcTuner_Property_G_JAPAN_STATION_NAME_LIST(poclTmcTuner_Property_G_JAPAN_STATION_NAME_LIST)
,m_poclAars_ATPresetList_XX(poclAars_ATPresetList_XX)
{
	signed int s32OsalError = OSAL_s32TimerCreate( ( OSAL_tpfCallback )vTimeoutNotificationCallback, (void* )this, &m_hNotificationAfter10sec_Timer );
	if( s32OsalError == OSAL_ERROR )
	{
		NORMAL_M_ASSERT( s32OsalError != OSAL_ERROR );
	}
}


/******************************************************************************
*
******************************************************************************/
void clTmcTuner_Method_S_JAPAN_SELECT_STATION_NAME::vMethodStart(amt_tclServiceData* poInMsg)
{
	 if(m_poclJapanStationName==NULL || m_poclTmcTuner_Property_G_JAPAN_STATION_NAME_LIST==NULL ||
			 ((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToADR==NULL)
	 {
		 NORMAL_M_ASSERT(m_poclJapanStationName != NULL);
		 NORMAL_M_ASSERT(m_poclTmcTuner_Property_G_JAPAN_STATION_NAME_LIST != NULL);
		 NORMAL_M_ASSERT(((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToADR != NULL);
		 return;
	 }
    
	 ETG_TRACE_USR4(("clTmcTuner_Method_S_JAPAN_SELECT_STATION_NAME: MethodStart"));
    m_poCCAhandler->vGetDataFromAmt(poInMsg, m_oMessage);
    oResult.TunerServer_StatusResponse.u8TunerState.enType = midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;
    if(m_poclJapanStationName->u8GetStationCount() > 1)
    {
       oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED;
       vHandleSelectionMode();
    }
    else
    {
   	 oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL;
    }
    vSendMethodResult(oResult);
 }


/******************************************************************************
*
******************************************************************************/
void clTmcTuner_Method_S_JAPAN_SELECT_STATION_NAME::vHandleSelectionMode()
{
	if(m_oMessage.e8SelectMode.enType == midw_fi_tcl_e8_Tun_SelectMode::FI_EN_TUN_SELECTMODE_ABSOLUTE)
	{
		ETG_TRACE_USR4(("Selected Mode is Absoulte. Index ID = %d", m_oMessage.u16ElementID));
		vHandleElementIDValue();
	}
	else if (m_oMessage.e8SelectMode.enType == midw_fi_tcl_e8_Tun_SelectMode::FI_EN_TUN_SELECTMODE_RELATIVE)
	{
		ETG_TRACE_USR4(("Selected Mode is Relative. Direction = %d", m_oMessage.e8Direction.enType));
		vHandleDirectionValue();
	}
	else
	{
		ETG_TRACE_USR4(("Invalid Selected Mode "));
		oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL;
	}
}


/******************************************************************************
*
******************************************************************************/
void clTmcTuner_Method_S_JAPAN_SELECT_STATION_NAME::vHandleElementIDValue()
{
	if(m_poclAars_ATPresetList_XX == NULL || ((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToHMI==NULL )
	{
		NORMAL_M_ASSERT (m_poclAars_ATPresetList_XX != NULL);
		NORMAL_M_ASSERT(((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToHMI != NULL);
		return;
	}

	//check if requested ID is available in station name list
	if(!(m_poclJapanStationName->bIsStationNamePresent(m_oMessage.u16ElementID)))
	{
		oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL;
	}
	else
	{
		if(m_poclJapanStationName->bSelectStationName(m_oMessage.u16ElementID))
		{
			//update new station name to clients only when station name is different than current selected.
			((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToADR->vSendGetAtStationInfo();
			m_poclTmcTuner_Property_G_JAPAN_STATION_NAME_LIST->vSendStatusToClient();      
			//update the presetlist
			m_poclAars_ATPresetList_XX->vGetPresetList(U16GetADR3PresetListID((midw_fi_tcl_e8_Tun_TunerBand::tenType)((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToHMI->m_u8PrevBand));
		   // send station list update on timeout.
		   (void)OSAL_s32TimerSetTime( m_hNotificationAfter10sec_Timer,CHANESTATIONNAMETIMEOUT , 0 );
		}
	}
}


/******************************************************************************
*
******************************************************************************/
void clTmcTuner_Method_S_JAPAN_SELECT_STATION_NAME::vHandleDirectionValue()
{
	if(m_poclAars_ATPresetList_XX == NULL || ((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToHMI==NULL)
	{
		NORMAL_M_ASSERT (m_poclAars_ATPresetList_XX != NULL);
		NORMAL_M_ASSERT(((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToHMI != NULL);
		return;
	}
	if((m_oMessage.e8Direction.enType == midw_fi_tcl_e8_Tun_RelativeDirection::FI_EN_TUN_RELATIVE_DECREMENT) ||
			(m_oMessage.e8Direction.enType == midw_fi_tcl_e8_Tun_RelativeDirection::FI_EN_TUN_RELATIVE_INCREMENT))
	{
		   m_poclJapanStationName->vSendStationName(m_oMessage.e8Direction.enType);
		   //update new station name to clients
		  ((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToADR->vSendGetAtStationInfo();
		  //station name list update to be posted when name is changed next/prev
		  m_poclTmcTuner_Property_G_JAPAN_STATION_NAME_LIST->vSendStatusToClient();
		  //update the presetlist
	      m_poclAars_ATPresetList_XX->vGetPresetList(U16GetADR3PresetListID((midw_fi_tcl_e8_Tun_TunerBand::tenType)((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToHMI->m_u8PrevBand));  
		  // send station list update on timeout.
		  (void)OSAL_s32TimerSetTime( m_hNotificationAfter10sec_Timer,CHANESTATIONNAMETIMEOUT , 0 );
	}
	else
		oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL;
}

/******************************************************************************
*
******************************************************************************/
OSAL_tpfCallback  clTmcTuner_Method_S_JAPAN_SELECT_STATION_NAME::vTimeoutNotificationCallback(void* /*pArg*/)
{
	ETG_TRACE_USR4(("vTimeoutNotificationCallback:: Timed out.. call list update now for new station name"));
	//for SDS command : inform registered clients that station list update is available (when station name is changed by user, new station names should be packed for station list.
	//so fake that there is a new list update so that new names can be posted to clients using CM_StationListConfig request.
	clTmcTuner_TMCTunerControl oTunerControl;
	oTunerControl.vOnCM_ChangeOfSurveilledStationsStatus();
	return 0;
}
