/************************************************************************
 * FILE:            clTmcTuner_Method_S_JAPAN_CHANGE_STATION_NAME.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clTmcTuner_Method_S_JAPAN_CHANGE_STATION_NAME.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
	26.08.2016				pmn3kor	
 *************************************************************************/


#include "AMFMTuner/clTmcTuner_Method_S_JAPAN_CHANGE_STATION_NAME.h"
#include "CcaApp/clCCAhandler.h"
#include "tun_MsgFromHMI.h"
#include "tun_MsgToHMI.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "tun_defines.h"

#include "tuner_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Method_S_JAPAN_CHANGE_STATION_NAME.cpp.trc.h"
#endif

#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"
#else
#include "amt_mock/amt_if.h"
#endif

OSAL_tTimerHandle  clTmcTuner_Method_S_JAPAN_CHANGE_STATION_NAME::m_hNotificationAfter10sec_Timer = 0;

using namespace tuner::CcaApp;

/******************************************************************************
*
******************************************************************************/
clTmcTuner_Method_S_JAPAN_CHANGE_STATION_NAME::~clTmcTuner_Method_S_JAPAN_CHANGE_STATION_NAME()
{
   m_poclJapanStationName = 0;
   if(OSAL_C_INVALID_HANDLE != m_hNotificationAfter10sec_Timer)
	{
		(void)OSAL_s32TimerDelete(m_hNotificationAfter10sec_Timer);
		m_hNotificationAfter10sec_Timer=OSAL_C_INVALID_HANDLE;
	}
}

/******************************************************************************
*
******************************************************************************/
clTmcTuner_Method_S_JAPAN_CHANGE_STATION_NAME::clTmcTuner_Method_S_JAPAN_CHANGE_STATION_NAME(
      tuner::CcaApp::clCCAhandler* poCCAhandler, clJapanStationName *poclJapanStationName)
:clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_JAPAN_CHANGE_STATION_NAME, poCCAhandler)
, m_poclJapanStationName(poclJapanStationName)
{
	signed int s32OsalError = OSAL_s32TimerCreate( ( OSAL_tpfCallback )vTimeoutNotificationCallback, (void* )this, &m_hNotificationAfter10sec_Timer );
	if( s32OsalError == OSAL_ERROR )
	{
		NORMAL_M_ASSERT( s32OsalError != OSAL_ERROR );
	}
}

/******************************************************************************
*
******************************************************************************/
OSAL_tpfCallback  clTmcTuner_Method_S_JAPAN_CHANGE_STATION_NAME::vTimeoutNotificationCallback(void* /*pArg*/)
{
	ETG_TRACE_USR4(("vTimeoutNotificationCallback:: Timed out.. call list update now for new station name"));
	//for SDS command : inform registered clients that station list update is available (when station name is changed by user, new station names should be packed for station list.
    //so fake that there is a new list update so that new names can be posted to clients using CM_StationListConfig request.
    clTmcTuner_TMCTunerControl oTunerControl;
    oTunerControl.vOnCM_ChangeOfSurveilledStationsStatus();
	 return 0;
}

/******************************************************************************
*
******************************************************************************/
void clTmcTuner_Method_S_JAPAN_CHANGE_STATION_NAME::vMethodStart(amt_tclServiceData* poInMsg)
{
    ETG_TRACE_USR4(("clTmcTuner_Method_S_JAPAN_CHANGE_STATION_NAME: MethodStart"));

    if(m_poclJapanStationName==NULL || ((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToADR==NULL)
    {
   	 NORMAL_M_ASSERT(m_poclJapanStationName!=NULL);
   	 NORMAL_M_ASSERT(((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToADR!=NULL);
   	 return;
    }

    m_poCCAhandler->vGetDataFromAmt(poInMsg, m_oMessage);
    midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodResult oResult;
    oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL;
    oResult.TunerServer_StatusResponse.u8TunerState.enType = midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;

    if((m_poclJapanStationName->u8GetStationCount() > 1) &&
   		 ((m_oMessage.e8ChangeStationMode.enType == midw_fi_tcl_e8_Tun_ChangeStationMode::FI_EN_TUN_UP)||
   				 (m_oMessage.e8ChangeStationMode.enType == midw_fi_tcl_e8_Tun_ChangeStationMode::FI_EN_TUN_DOWN)))
    {
   	 //workaround for direction. This FI will be removed after one/two months. So providing workaround of this FI instead of FID_TUN_S_JAPAN_SELECT_STATION_NAME
   	 vInterChangeStationMode();

       //iterate the station name and update database
       m_poclJapanStationName->vSendStationName(m_oMessage.e8ChangeStationMode.enType);
       ((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToADR->vSendGetAtStationInfo();

       oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED;

	   // send station list update on timeout.
       (void)OSAL_s32TimerSetTime( m_hNotificationAfter10sec_Timer,CHANESTATIONNAMETIMEOUT , 0 );
    }
    else
    {
       //error handling if stationcount is less than 1 (0 or 1) for selected area code and frequency this method should not be called.
       //because user will not get to know any change in HMI station name. So either HMI has to block this button if stationcount is 1/0 else we will send fail result.
       ETG_TRACE_USR4(("clTmcTuner_Method_S_JAPAN_CHANGE_STATION_NAME: Stationcount less than or equal to 1 or invalid station mode"));
    }
    vSendMethodResult(oResult);
 }


/******************************************************************************
*
******************************************************************************/
void clTmcTuner_Method_S_JAPAN_CHANGE_STATION_NAME::vInterChangeStationMode()
{
	//This interchange is done to resuse clJapanStationName::vSendStationName function.
	//In FID_TUN_S_JAPAN_SELECT_STATION_NAME Increment=1 and decrement=2, here up=0 and down=1. So reverse internally for workaround
	if(m_oMessage.e8ChangeStationMode.enType == midw_fi_tcl_e8_Tun_ChangeStationMode::FI_EN_TUN_UP)
		m_oMessage.e8ChangeStationMode.enType = midw_fi_tcl_e8_Tun_ChangeStationMode::FI_EN_TUN_DOWN;
	else if (m_oMessage.e8ChangeStationMode.enType == midw_fi_tcl_e8_Tun_ChangeStationMode::FI_EN_TUN_DOWN)
		m_oMessage.e8ChangeStationMode.enType = midw_fi_tcl_e8_Tun_ChangeStationMode::FI_EN_TUN_UP;

}
