/************************************************************************
 * FILE:           clTmcTuner_Method_S_DISABLE_BAND.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_DISABLE_BAND.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
						
 *************************************************************************/


#ifndef clTmcTuner_Method_S_DISABLE_BAND_h
#define clTmcTuner_Method_S_DISABLE_BAND_h


#include "CcaApp/clServerMethod.h"
#include "ADRMsg/ADRMsg_if.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "interface/clTmcTuner_HMI_ImpInterface.h"
#include "conversionTable/midwTunerToAdr3Map.h"

struct stDisableBandRequest
{
	tBool blIsDisableBandRequested;
	midw_fi_tcl_e8_Tun_TunerBand::tenType midwTunerBand;

};
class clAars_ATPresetList_XX;
class clAars_CM_ChangeLsm;
class clTmcTuner_Property_G_GET_STATIC_LIST;
class clAars_ATFrequency;
class dp_tclTunerImpl;
class clTmcTuner_Method_S_DISABLE_BAND : public tuner::CcaApp::clServerMethod, public clTmcTuner_HMI_ImpInterface
{
   public:
      virtual ~clTmcTuner_Method_S_DISABLE_BAND();
      clTmcTuner_Method_S_DISABLE_BAND( tuner::CcaApp::clCCAhandler* poCCAhandler, clAars_ATPresetList_XX* poATPresetList_XX,clAars_CM_ChangeLsm* poclAars_CM_ChangeLsm,tun_Config* potun_Config,clTmcTuner_Property_G_GET_STATIC_LIST* poclTmcTuner_Property_G_GET_STATIC_LIST,clAars_ATFrequency* poclAars_ATFrequency,tun_MsgFromHMI* potun_MsgFromHMI);
	  stDisableBandRequest stGetDisableBandRequested();
	  tVoid vSendDisableBandMethodResult();
	  tVoid vSetdp_tclTunerImplPtr(dp_tclTunerImpl* podp_tclTunerImpl);
   private:
      virtual tVoid vMethodStart(amt_tclServiceData* poInMsg);
      clAars_ATPresetList_XX* m_poATPresetList_XX;
	  clAars_CM_ChangeLsm* m_poclAars_CM_ChangeLsm;
	  tun_Config* m_potun_Config;
	  stDisableBandRequest m_stDisableBandRequest;
	  clTmcTuner_Property_G_GET_STATIC_LIST* m_poclTmcTuner_Property_G_GET_STATIC_LIST;
	  clAars_ATFrequency* m_poclAars_ATFrequency;
	  tun_MsgFromHMI* m_potun_MsgFromHMI;
	  dp_tclTunerImpl* m_podp_tclTunerImpl;
};


#endif