/************************************************************************
 * FILE:         clTmcTuner_Method_S_DARC_NO_VICS_DATA_AVAILABLE.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_DARC_NO_VICS_DATA_AVAILABLE.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
			auj1kor
				
 *************************************************************************/

#include "AMFMTuner/clTmcTuner_Method_S_DARC_NO_VICS_DATA_AVAILABLE.h"
#include "AMFMTuner/clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST.h"
#include "AMFMTuner/clTmcTuner_Property_G_GET_DARC_DATA.h"
#include "CcaApp/clCCAhandler.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"

using namespace tuner::CcaApp;

#include "tuner_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Method_S_DARC_NO_VICS_DATA_AVAILABLE.cpp.trc.h"
#endif

clTmcTuner_Method_S_DARC_NO_VICS_DATA_AVAILABLE::~clTmcTuner_Method_S_DARC_NO_VICS_DATA_AVAILABLE()
{
	m_poclTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST = NULL;
	m_poclTmcTuner_Property_G_GET_DARC_DATA = NULL;
}


clTmcTuner_Method_S_DARC_NO_VICS_DATA_AVAILABLE::clTmcTuner_Method_S_DARC_NO_VICS_DATA_AVAILABLE( tuner::CcaApp::clCCAhandler* poCCAhandler )
:clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_DARC_NO_VICS_DATA_AVAILABLE, poCCAhandler)
{
	m_poclTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST = NULL;
	m_poclTmcTuner_Property_G_GET_DARC_DATA = NULL;
}

tVoid clTmcTuner_Method_S_DARC_NO_VICS_DATA_AVAILABLE::vSet_G_GET_DARC_DATA_Ptr(clTmcTuner_Property_G_GET_DARC_DATA* poclTmcTuner_Property_G_GET_DARC_DATA)
{
	if(poclTmcTuner_Property_G_GET_DARC_DATA != NULL)
	{
		m_poclTmcTuner_Property_G_GET_DARC_DATA = poclTmcTuner_Property_G_GET_DARC_DATA;
	}
}

tVoid clTmcTuner_Method_S_DARC_NO_VICS_DATA_AVAILABLE::vSet_S_DARC_VICS_FREQUENCY_LIST(clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST* poclTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST)
{
	if(poclTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST != NULL)
	{
		m_poclTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST = poclTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST;
	}
}


tVoid clTmcTuner_Method_S_DARC_NO_VICS_DATA_AVAILABLE::vMethodStart(amt_tclServiceData* poInMsg)
{	
	if(m_poclTmcTuner_Property_G_GET_DARC_DATA == NULL || m_poclTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST == NULL)
	{
		ETG_TRACE_USR4(("clTmcTuner_Method_S_DARC_NO_VICS_DATA_AVAILABLE: vMethodStart , null pointer"));
		return;
	}
    ETG_TRACE_USR4(("clTmcTuner_Method_S_DARC_NO_VICS_DATA_AVAILABLE: MethodStart"));
    midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodStart m_oMessage;
    m_poCCAhandler->vGetDataFromAmt(poInMsg, m_oMessage);
	midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodResult oResult;

	m_poclTmcTuner_Property_G_GET_DARC_DATA->vStopDARCTimer();
    m_poclTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST->vRequestDARCData();

	oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED;
	oResult.TunerServer_StatusResponse.u8TunerState.enType = midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;

	vSendMethodResult(oResult);
}

