/************************************************************************
 * FILE:         clTmcTuner_Method_S_CONFIGLIST_UPDATE.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_CONFIGLIST_UPDATE.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
	Jul 1, 2015			rrb1kor
				
 *************************************************************************/



#ifndef CLTMCTUNER_METHOD_S_CONFIGLIST_UPDATE_H_
#define CLTMCTUNER_METHOD_S_CONFIGLIST_UPDATE_H_

#include "CcaApp/clServerMethod.h"
#include "ADRMsg/ADRMsg_if.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "interface/clTmcTuner_HMI_ImpInterface.h"
#include "TunerApp/Mute/clMuteInterface.h"

class clAars_CM_UpdateLandscape;

class clConfigListUpdateMuteData
{
public:
	virtual ~clConfigListUpdateMuteData() {}
	midw_fi_tcl_e8_Tun_ConfigListID::tenType m_e8ConfigListID;
	bool m_bStatus;
	clConfigListUpdateMuteData();
};

class clTmcTuner_Method_S_CONFIGLIST_UPDATE : public tuner::CcaApp::clServerMethod, public clTmcTuner_HMI_ImpInterface, public Mute::clMuteInterface
{
   public:
      virtual ~clTmcTuner_Method_S_CONFIGLIST_UPDATE();
      clTmcTuner_Method_S_CONFIGLIST_UPDATE( tuner::CcaApp::clCCAhandler* poCCAhandler,clAars_CM_UpdateLandscape *poclAars_CM_UpdateLandscape);

   private:
      virtual tVoid vMethodStart(amt_tclServiceData* poInMsg);
      virtual void vOnCM_UpdateLandscapeResult();
	  virtual void vOnCM_UpdateLandscapeError();
	  void vStoreConfigListUpdateData(midw_fi_tcl_e8_Tun_ConfigListID::tenType u8ConfigListID, bool bStatus);
	  virtual void vProcessTunerAction();
	  virtual void vOnNewMuteTunerAction(Mute::MuteHandling::enMuteTuningAction muteAction);
	  virtual void vOnAudioMuteRequest();
	  virtual void vOnDemuteSendMethodResult();
	  virtual void vOnTunerStateIdle();
	  virtual void vClearStoredRequest();
	  tBool bIsValidData();
	  void vSendFailedMethodResult();

      clAars_CM_UpdateLandscape* m_poclAars_CM_UpdateLandscape;
	  clConfigListUpdateMuteData m_oMuteData;
	  tBool m_bSendMethodResult;

};
#endif /* CLTMCTUNER_METHOD_S_CONFIGLIST_UPDATE_H_ */
