/************************************************************************
 * FILE:         clTmcTuner_Method_S_CONFIGLIST_UPDATE.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_CONFIGLIST_UPDATE
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
	Jul 1, 2015			rrb1kor
				
 *************************************************************************/



#include "clTmcTuner_Method_S_CONFIGLIST_UPDATE.h"
#include "CcaApp/clCCAhandler.h"
#include "conversionTable/midwTunerToAdr3Map.h"
#include "Aars/clAars_CM_UpdateLandscape.h"
#include "TunerApp/Mute/MuteHandling/clMuteImpl.h"

using namespace tuner::CcaApp;
using namespace Mute::MuteHandling;

#include "tun_trace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGFROMHMI
#include "trcGenProj/Header/clTmcTuner_Method_S_CONFIGLIST_UPDATE.cpp.trc.h"
#endif
/*****************************************************************************
* Destructor
******************************************************************************/
clTmcTuner_Method_S_CONFIGLIST_UPDATE::~clTmcTuner_Method_S_CONFIGLIST_UPDATE()
{
	m_poclAars_CM_UpdateLandscape=NULL;
	m_bSendMethodResult = false;
}
/*****************************************************************************
* Constructor
******************************************************************************/
clTmcTuner_Method_S_CONFIGLIST_UPDATE::clTmcTuner_Method_S_CONFIGLIST_UPDATE(tuner::CcaApp::clCCAhandler* poCCAhandler,clAars_CM_UpdateLandscape* poclAars_CM_UpdateLandscape)
   : clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_CONFIGLIST_UPDATE, poCCAhandler)
{
	m_poclAars_CM_UpdateLandscape=poclAars_CM_UpdateLandscape;
	m_bSendMethodResult = false;
}


/*****************************************************************************
* vMethodStart
******************************************************************************/
tVoid clTmcTuner_Method_S_CONFIGLIST_UPDATE::vMethodStart(amt_tclServiceData* poInMessage)
{
	//ETG_TRACE_USR4(("clTmcTuner_Method_S_CONFIGLIST_UPDATE::vMethodStart()"));
	midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodStart oMessage;
	m_poCCAhandler->vGetDataFromAmt(poInMessage, oMessage);
	m_bSendMethodResult = true;
	vStoreConfigListUpdateData(oMessage.e8ConfigListID.enType, oMessage.bStatus);
	/*Send Mute request if update landscape to be started */
	if(oMessage.bStatus == true)
	{
		vOnNewMuteTunerAction(Mute::MuteHandling::CONFIGLISTUPDATE);
	}
	else
	{
		vProcessTunerAction();
	}
}
tVoid clTmcTuner_Method_S_CONFIGLIST_UPDATE::vOnCM_UpdateLandscapeResult()
{
	/*Send DeMute only if configlist update is Current action and not received tuner state as idle for update config list */
	if(!m_oMuteData.m_bStatus && (clMuteImpl::instance()->getCurrentMuteTuningAction() == Mute::MuteHandling::CONFIGLISTUPDATE) )
	{
		clMuteImpl::instance()->vOnNewMuteState(Mute::MuteHandling::DEMUTE);
	}
	if(m_bSendMethodResult)
	{
		midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodResult oResult;
		oResult.TunerServer_StatusResponse.u8TunerState.enType =midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;
		oResult.TunerServer_StatusResponse.u8TunerStatus.enType=midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED;
		vSendMethodResult(oResult);
		m_bSendMethodResult = false;
	}
}
tVoid clTmcTuner_Method_S_CONFIGLIST_UPDATE::vOnCM_UpdateLandscapeError()
{
	m_oMuteData.m_bStatus = false;
	clMuteImpl::instance()->vOnNewMuteState(Mute::MuteHandling::DEMUTE);
	vSendFailedMethodResult();
}

void clTmcTuner_Method_S_CONFIGLIST_UPDATE::vSendFailedMethodResult()
{
	midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodResult oResult;
	oResult.TunerServer_StatusResponse.u8TunerState.enType =midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;
	oResult.TunerServer_StatusResponse.u8TunerStatus.enType=midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL;
	vSendMethodResult(oResult);
	m_bSendMethodResult = false;
}

clConfigListUpdateMuteData::clConfigListUpdateMuteData() : m_e8ConfigListID(midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_INVALID_TYPE), m_bStatus(false)
{

}

void clTmcTuner_Method_S_CONFIGLIST_UPDATE::vStoreConfigListUpdateData(midw_fi_tcl_e8_Tun_ConfigListID::tenType e8ConfigListID, bool bStatus)
{
	m_oMuteData.m_e8ConfigListID = e8ConfigListID;
	m_oMuteData.m_bStatus = bStatus;
}

void clTmcTuner_Method_S_CONFIGLIST_UPDATE::vProcessTunerAction()
{
	if(bIsValidData())
	{
		unsigned int Band = 0;
		if(m_oMuteData.m_bStatus)
		{
			Band= enGetADR3StationListBandBit(m_oMuteData.m_e8ConfigListID);
			/*after forwearding data to ADR, clear request */
			m_oMuteData.m_e8ConfigListID = midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_INVALID_TYPE;
		}
		m_poclAars_CM_UpdateLandscape->vUpdateLandscape(Band);
	}
}
void clTmcTuner_Method_S_CONFIGLIST_UPDATE::vOnNewMuteTunerAction(Mute::MuteHandling::enMuteTuningAction muteAction)
{
	ETG_TRACE_USR4(( "clTmcTuner_Method_S_CONFIGLIST_UPDATE::vOnNewMuteTunerAction() muteAction = %d", muteAction));
	clMuteImpl::instance()->vOnNewMuteTunerAction(muteAction);
	ETG_TRACE_USR4(( "clTmcTuner_Method_S_CONFIGLIST_UPDATE::vOnNewMuteTunerAction() muteImpl = %p", clMuteImpl::instance()));
}
void clTmcTuner_Method_S_CONFIGLIST_UPDATE::vOnAudioMuteRequest()
{

}
void clTmcTuner_Method_S_CONFIGLIST_UPDATE::vOnDemuteSendMethodResult()
{

}
void clTmcTuner_Method_S_CONFIGLIST_UPDATE::vOnTunerStateIdle()
{

}

void clTmcTuner_Method_S_CONFIGLIST_UPDATE::vClearStoredRequest()
{
	ETG_TRACE_USR4(( "clTmcTuner_Method_S_CONFIGLIST_UPDATE::vClearStoredRequest()"));
	m_oMuteData.m_e8ConfigListID = midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_INVALID_TYPE;
	m_oMuteData.m_bStatus = false;
	vSendFailedMethodResult();
}


tBool clTmcTuner_Method_S_CONFIGLIST_UPDATE::bIsValidData()
{
	if((m_oMuteData.m_e8ConfigListID == midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_INVALID_TYPE))
	{
		return false;
	}
	else
	{
		return true;
	}
}

