/************************************************************************
 * FILE:         clTmcTuner_Method_S_CHANGE_LSM.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_CHANGE_LSM
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
					  auj1kor
				
 *************************************************************************/

#include "AMFMTuner/clTmcTuner_Method_S_CHANGE_LSM.h"
#include "CcaApp/clCCAhandler.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "Aars/clAars_CM_ChangeLsm.h"
#include "conversionTable/midwTunerToAdr3Map.h"

using namespace tuner::CcaApp;

#include "tuner_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Method_S_CHANGE_LSM.cpp.trc.h"
#endif

clTmcTuner_Method_S_CHANGE_LSM::~clTmcTuner_Method_S_CHANGE_LSM()
{
	m_poclAars_CM_ChangeLsm = NULL;
}


clTmcTuner_Method_S_CHANGE_LSM::clTmcTuner_Method_S_CHANGE_LSM( tuner::CcaApp::clCCAhandler* poCCAhandler , clAars_CM_ChangeLsm* poclAars_CM_ChangeLsm)
:clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_CHANGE_LSM, poCCAhandler)
{
	m_poclAars_CM_ChangeLsm = poclAars_CM_ChangeLsm;
}

tVoid clTmcTuner_Method_S_CHANGE_LSM::vMethodStart(amt_tclServiceData* poInMsg)
{
    ETG_TRACE_USR4(("clTmcTuner_Method_S_CHANGE_LSM: MethodStart"));

    m_poCCAhandler->vGetDataFromAmt(poInMsg, m_oMessage);
	      	  		
    switch((tU8)m_oMessage.Option.enType)
    {
    	case (tU8)midw_fi_tcl_e8_StationSelectionOption::FI_EN_FREQUENCY_INPUT :
    		{
    			m_poclAars_CM_ChangeLsm->vSendChangeLSMDirectFreqInput((unsigned char)m_oMessage.Band.enType , m_oMessage.Frequency , (tU16)m_oMessage.PI);
    			break;
    		}
    	case (tU8)midw_fi_tcl_e8_StationSelectionOption::FI_EN_HDSTATIONID_INPUT :
    		{
    			m_poclAars_CM_ChangeLsm->vSendChangeLSMHDAudioProgramInput((unsigned char)m_oMessage.Band.enType , m_oMessage.Frequency , m_oMessage.PI , m_oMessage.HDProgramNumber);
    			break;
    		}
    	case (tU8)midw_fi_tcl_e8_StationSelectionOption::FI_EN_DRMSERVICEID_INPUT :
    		{
    			m_poclAars_CM_ChangeLsm->vSendChangeLSMDRMStationIDInput((unsigned char)m_oMessage.Band.enType , m_oMessage.Frequency , m_oMessage.PI);
    			break;
    		}
    	case (tU8)midw_fi_tcl_e8_StationSelectionOption::FI_EN_PRESET_INPUT :
    		{
    			m_poclAars_CM_ChangeLsm->vSendChangeLSMPresetNumberInput(U16GetADR3PresetListID(m_oMessage.e8ListID.enType) , m_oMessage.u8Element_ID);
    			break;
    		}
    	default :
			{
				vOnChangeLsmError();
				ETG_TRACE_USR4(("clTmcTuner_Method_S_CHANGE_LSM: MethodStart , invalid option"));
				break;
			}
    }
	
	
}
tVoid clTmcTuner_Method_S_CHANGE_LSM::vOnChangeLsmStatus()
{
	ETG_TRACE_USR4(("clTmcTuner_Method_S_CHANGE_LSM: vOnChangeLsmStatus"));
	midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodResult oResult;
	oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED;
	oResult.TunerServer_StatusResponse.u8TunerState.enType = midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;
	vSendMethodResult(oResult);
}
tVoid clTmcTuner_Method_S_CHANGE_LSM::vOnChangeLsmError()
{
	ETG_TRACE_USR4(("clTmcTuner_Method_S_CHANGE_LSM: vOnChangeLsmError"));
	midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodResult oResult;
	oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL;
	oResult.TunerServer_StatusResponse.u8TunerState.enType = midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;
	vSendMethodResult(oResult);
	
}
