/************************************************************************
 * FILE:         clTmcTuner_Method_S_AUDIO_FG_BG_NEW.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  header of  clTmcTuner_Method_S_AUDIO_FG_BG_NEW
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/


#ifndef clTmcTuner_Method_S_AUDIO_FG_BG_NEW_h
#define clTmcTuner_Method_S_AUDIO_FG_BG_NEW_h


#include "CcaApp/clServerMethod.h"
#include "ADRMsg/ADRMsg_if.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "interface/clTmcTuner_HMI_ImpInterface.h"

class clAars_MTCAudioSource;
class clAars_AudioSource;
class clAars_SpecialDiagnosisMode;
class tun_MsgFromHMI;
class tun_MsgToHMI;
class tun_ActualData;

class clConfigInterface;
class clTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY;

class clTmcTuner_Method_S_AUDIO_FG_BG_NEW : public tuner::CcaApp::clServerMethod, public clTmcTuner_HMI_ImpInterface
{
   public:
      virtual ~clTmcTuner_Method_S_AUDIO_FG_BG_NEW();
      clTmcTuner_Method_S_AUDIO_FG_BG_NEW(tuner::CcaApp::clCCAhandler* poCCAhandler, clAars_AudioSource* poAudioSource, clAars_MTCAudioSource* poMTCAudioSource,  clAars_SpecialDiagnosisMode* poSpecialDiagnosisMode,
    		  tun_MsgToHMI* potun_MsgToHMI, tun_ActualData* potun_ActualData,clConfigInterface* poclConfigInterface);
      virtual void vOnNewTunerFGBGStatus(unsigned char AudioSource);
      void vSetTunerMode(unsigned char u8NewVal);
      unsigned char u8GetTunerMode();
      void vSetMeasureMode(unsigned char u8NewVal);
      unsigned char u8GetMeasureMode();
	  void vSendFGBGMethodResult();
	  void vSet_tun_MsgFromHMI_Ptr( tun_MsgFromHMI* potun_MsgFromHMI );
	  void vSet_TmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCYPtr( clTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY* poclTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY );
	  bool bIsBandChangeRequested();
	  void vSetBandChangeRequested(bool);
      bool IsUserSwitchedTunerToFG();
   private:
      virtual tVoid vMethodStart(amt_tclServiceData* poInMsg);
      bool bIsTestModeActive();
      bool bIsToForegroundRequest();
      void vOnForeGroundRequest();
      void vOnBackGroundRequest();
      bool bIsTunerInForeGround();
      bool bIsNonUserSink();
      clCMEnum_AudioSource::enAudioSource getAudioSource();
      void vTestModeReq();


      clAars_MTCAudioSource* m_poMTCAudioSource;
      clAars_AudioSource* m_poAudioSource;
      clAars_SpecialDiagnosisMode* m_poSpecialDiagnosisMode;
	  tun_MsgFromHMI* m_potun_MsgFromHMI;
	  tun_MsgToHMI* m_potun_MsgToHMI;
	  tun_ActualData* m_potun_ActualData;
	  clConfigInterface* m_poclConfigInterface;
	  clTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY* m_poclTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY;
	  midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodResult m_oResult;

      unsigned char m_u8TunerMode;
      unsigned char m_u8MeasurementMode;
	  bool m_blBandChangeRequested;

      midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodStart m_oMessage;

};


#endif
