/************************************************************************
 * FILE:         clTmcTuner_Method_DRM_TestMode.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clTmcTuner_Method_DRM_TestMode.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/


#include "AMFMTuner/clTmcTuner_Method_DRM_TestMode.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "CcaApp/clCCAhandler.h"
#include "Aars/clAars_DRMTestMode.h"

#include "tuner_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Method_DRM_TestMode.cpp.trc.h"
#endif

//using namespace tuner::drm;
using namespace tuner::CcaApp;

/*****************************************************************************
* Destructor
******************************************************************************/
clTmcTuner_Method_DRM_TestMode::~clTmcTuner_Method_DRM_TestMode()
{

   m_poDRMTestMode = NULL;
}


/******************************************************************************
* Constructor
******************************************************************************/
clTmcTuner_Method_DRM_TestMode::clTmcTuner_Method_DRM_TestMode(clCCAhandler* poCCAhandler, clAars_DRMTestMode* poDRMTestMode)
   : clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_DRM_TESTMODE, poCCAhandler)
     ,m_poDRMTestMode(poDRMTestMode)
{

}


/*****************************************************************************
*
******************************************************************************/
tVoid clTmcTuner_Method_DRM_TestMode::vMethodStart(amt_tclServiceData* poInMessage )
{
   ETG_TRACE_USR4(("clTmcTuner_Method_DRM_TestMode: MethodStart"));
   m_poCCAhandler->vGetDataFromAmt(poInMessage, m_oMessage);

   vSendDRMTestModeRequestToAars();
    midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodResult oResult;
    vSendMethodResult(oResult);
}


tVoid clTmcTuner_Method_DRM_TestMode::vSendDRMTestModeRequestToAars()
{
   unsigned char u8DRMTestModeActivity = m_oMessage.e8DRMTestModeActivity.enType;
   clCMEnum_TestmodeActivity DRMTestModeActivity;
   DRMTestModeActivity.enType = static_cast<clCMEnum_TestmodeActivity::enTestmodeActivity> (u8DRMTestModeActivity);
   m_poDRMTestMode->vSetDRMTestModeActivity(DRMTestModeActivity);
}


