/************************************************************************
 * FILE:           clHDImageMemoryManagement.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clHDImageMemoryManagement.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification

 *************************************************************************/

#ifndef _CLHDIMAGEMEMORYMANAGEMENT_H_
#define _CLHDIMAGEMEMORYMANAGEMENT_H_

#include "ADRMsg/ADRMsg_if.h"
#include <list>
#include <map>

#ifndef VARIANT_S_FTR_ENABLE_DP_CLIENT_MOCK
	#define DP_S_IMPORT_INTERFACE_FI
	#include "dp_tuner_if.h"
	#include "dp_generic_if.h"
#else
	#include"diaglib_if.h"
#endif


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
/*
 * Include clock interface files
 */
#ifdef VARIANT_S_FTR_ENABLE_VDCLOCK

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#define CLOCK_FI_S_IMPORT_INTERFACE_CLOCK_MAINFI_DBGVISITORS
#define CLOCK_FI_S_IMPORT_INTERFACE_CLOCK_MAINFI_STDVISITORS
#define CLOCK_FI_S_IMPORT_INTERFACE_CLOCK_MAINFI_FUNCTIONIDS
#define CLOCK_FI_S_IMPORT_INTERFACE_CLOCK_MAINFI_SERVICEINFO
#define CLOCK_FI_S_IMPORT_INTERFACE_CLOCK_MAINFI_TYPES
#define CLOCK_FI_S_IMPORT_INTERFACE_FI_TYPES
#include "clock_fi_if.h"

#endif

typedef std::list<clCMATHDImageFileUpdateStatus> CoverArtImageDataQueue;
typedef std::map <unsigned char, CoverArtImageDataQueue > AudioProgramImageDataMap;
typedef std::map <unsigned long, AudioProgramImageDataMap> StationIDImageFileMap;
typedef std::list< StationIDImageFileMap > StationIDQueue;

typedef AudioProgramImageDataMap::iterator AudioProgramImageDataMapIterator;
typedef StationIDImageFileMap::iterator StationIDImageFileMapIterator;

typedef std::pair<unsigned char, CoverArtImageDataQueue> AudioProgramImageDataMapPair;
typedef std::pair<unsigned long, AudioProgramImageDataMap> StationIDImageFileMapPair;


class clHDImageMemoryManagement
{
private:

	StationIDQueue mStationIDQueue;

	bool bIsImageExistsForGivenStationID(unsigned int u32StationID, unsigned char u8AudioProgram, unsigned short u16LotID);
	bool bIsImageExistForGivenAudioProgram(unsigned char u8AudioProgram, unsigned short u16LotID, AudioProgramImageDataMap obj);
	bool bIsImageExistForGivenLotID(unsigned short u16LotID, CoverArtImageDataQueue obj);

	clCMATHDImageFileUpdateStatus oGetImageFileForGivenAudioProgram(unsigned char u8AudioProgram, unsigned short u16LotID, AudioProgramImageDataMap obj);
	clCMATHDImageFileUpdateStatus oGetImageFileForGivenLotID(unsigned short u16LotID, CoverArtImageDataQueue obj);

	void vAddImageToMap(AudioProgramImageDataMap* obj, clCMATHDImageFileUpdateStatus& objHDImageFileStatus);
	void vAddImageToMap(CoverArtImageDataQueue* obj, clCMATHDImageFileUpdateStatus& objHDImageFileStatus);
	bool bIsImageFileContentEqual(tunerVector<unsigned char> vReceivedImage, tunerVector<unsigned char> vExistingImage);

	StationIDImageFileMap vGetStationIDImageFileMap(clCMATHDImageFileUpdateStatus& objHDImageFileStatus);
	AudioProgramImageDataMap vGetAudioProgramImageFileMap(clCMATHDImageFileUpdateStatus& objHDImageFileStatus);
	CoverArtImageDataQueue vGetImageDataQueue(clCMATHDImageFileUpdateStatus& objHDImageFileStatus);

	void vFlushImagesFromMap(unsigned char u8AudioProgram, AudioProgramImageDataMap objAudioProgramImageDataMap);

public:

	clHDImageMemoryManagement( );
	virtual ~clHDImageMemoryManagement( );

	bool bIsImageExist(unsigned int u32StationID, unsigned char u8AudioProgram, unsigned short u16LotID);
	clCMATHDImageFileUpdateStatus objGetImageFromMap(unsigned int u32StationID, unsigned char u8AudioProgram, unsigned short u16LotID);
	void vAddImageToMap(clCMATHDImageFileUpdateStatus& objHDImageFileStatus);
	void vFlushImagesFromMap(unsigned int u32StationID, unsigned char u8AudioProgram);
};

class clVDClockData
{
public:
	   tS16 s16Year;
	   tU8 u8Month;
	   tU8 u8Day;

	   clVDClockData();
	   ~clVDClockData();
#ifdef VARIANT_S_FTR_ENABLE_VDCLOCK
	   void vUpdateClockData(clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus oMsg);
#endif
};

class clHDStationLogoManagement
{
private:
	short mNumberOfStationLogosInFlash;
#ifndef VARIANT_S_FTR_ENABLE_DP_CLIENT_MOCK
	dp_tclTmcTunerDPCurrentDate moDPCurrentDate;
#endif
	clVDClockData m_oclVDClockData;
	std::vector<std::string> vStationLogoFiles;

	bool bIsDeletionCheckToBeRun();
	void vGetFormattedDate(clVDClockData &oclVDClockData, const char * sCurrentDate);
	std::string strGetFormattedDate(const clVDClockData &oclVDClockData, bool bIsSpaceNeeded);
	void vGetFormattedString(std::string &strStationLogoName);
	bool bIsDateOlderThanSystemDate(const clVDClockData& oclVDClockData);
	bool bIsRcvdExpiredDatelatest(const clVDClockData& oExistingExpireDate, const clVDClockData& oReceivedExpireDate);
	void vHandleDeletionOfExpiredLogo();
	void vUpdateDateInDp();
	void vIntegerToString(char *strDestination, int& iStart, tU8 u8Source, int iLengthToBeCopied, bool bIsSpaceNeeded);
	void vDeleteExpiredStationLogo();
	void vGetNumberOfStationLogos(const char * strStationLogoDirectoryName, bool bIsStationLogoRAMPathExists);
	bool bIsStationLogoExpired(char *strStationLogoFileName);
	void vExtractSubString(char *dest, int& iDestOffset, const char *source, int& iSrcOffset, int iNumberOfBytesToBeCopied);
	bool bIsStationLogoExist(const std::string& strReceivedStationLogo);
	bool bIsReceivedStationLogoContentSame(std::string strReceivedStationLogo, std::vector<unsigned char> vReceivedLogoContent, bool& bIsFileNotExist);
	bool vCreateStationLogoFile(std::string strStationLogoAbsolutePath, std::vector<unsigned char> vImageFileBytes);
	void vRemoveStationLogoFileNameFromVector(std::string strFileName);
	std::string strFormattedHDStationId(unsigned int u32HDStationId);
	std::string strGetImageCodingType(unsigned char u8ImageCoding);
	void vDeleteAllLogosInPath(const char* strLogoPath);
	void vCopyLogoFromFlashToRAM();
	bool vCreateStationLogoFile(clCMATHDImageFileUpdateStatus& oImageFileData, unsigned int u32HDStationId);
	bool bDeleteOldestAccessedStationLogo();
	bool bIsExpiryDateUpdateNeeded(const std::string& strFileName, std::string& strExistingFileName);
	bool bReplaceStationLogo(const std::string& strFileName, clCMATHDImageFileUpdateStatus& oImageFileData);
    bool bIsValidDate(const clVDClockData& oclVDClockData);
public:

	clHDStationLogoManagement();
	~clHDStationLogoManagement();
#ifdef VARIANT_S_FTR_ENABLE_VDCLOCK
	void vOnVdClockStatus(clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus oMsg);
#endif
	bool vOnNewStationLogo(clCMATHDImageFileUpdateStatus& oImageFileData, unsigned int u32HDStationId);
	void vDeleteAllStationLogos();
	std::string strGetActiveStationLogoPath(unsigned int u32HDStationId, unsigned char u8AudioProgram);
	void vHandleHDStationLogo();
	void vDoDifferentialCopyLogosFromRAMToFlash();
};


#endif //_CLHDIMAGEMEMORYMANAGEMENT_H_
