/*
//====================================================================
// MWT_WSIRLEToPNG.h:
//
// TEST MODULE
//
// Copyright � 2005 WSI Corporation.  All rights reserved.
// Author: Damon M. Hill
//
// This is the public interface of a module which converts
// a single or multi-plane WSI RLE image into a single plane
// PNG file.
//
// The merging of plains is done by inspecting the Product ID to
// determine what the proper masks and shifts are.  The palette
// of the image is also assigned based on the Product ID.
//
//====================================================================
*/
#ifndef NO_SUPPORT_PNG

#ifndef MWT_WSIRLETOPNG_HEADER
#define MWT_WSIRLETOPNG_HEADER

/*
//====================================================================
// Required includes
//====================================================================
*/
#include "MW_DataFieldTypes.h"
#include "MW_ProductHeaders.h"

/*
//====================================================================
//====================================================================
// Public interface
//====================================================================
//====================================================================
*/

/*
//====================================================================
// MWTWSIRLEToPNG_convertRasterProductFile:
//
// This method converts a file who's path is given by the caller,
// and who's format is assumed to be that of a WSI for Sirius raster
// product file, into a bitmap image file.
//
// The image palette and way to merge the various image planes are
// determined by rules based on the ProductID of the source.
//
// PARAMETERS:
//
//	pstr_rasterProductPath:
//		Path to the raster product to be converted to a bitmap image.
//
//	pstr_outputPNGFilePath:
//		Path to the file to be created/replaced which will be
//		a Bitmap of the data in the raster product.
//
// RETURNS:
//
//	MWRes_Success
//
//	MWRes_OperationFailed:
//		If the source is not a raster product,
//		or the ProductID is not recognized,
//		or the bits per pixel of the raster > 8
//
//	MWRes_NullPointer:
//		If one of the path string pointers is a NULL pointer.
//
//	MWRes_BadParamValue:
//		If one of the files cannot be opened.
//
//	MWRes_CommunicationsError:
//		On a file error
//
//	MWRes_HeaderFieldInvalid:
//		If the number of planes in the raster does not match
//		the number of planes expected for the ProductID.
//
//	MWRes_ProductFormatInvalid
//		if something is wrong with the product
//
//	MWRes_OutOfMemory:
//		Not enough memory to create raster surface to merge planes
//
//	<Other> on error in file format
//====================================================================
*/
TMW_ResultCode MWTWSIRLEToPNG_convertRasterProductFile
(
	const TASCIIChar* pstr_rasterProductPath,
	const TASCIIChar* pstr_outputPNGFilePath,
	TMW_CompressionType sourceCompressionType,
	TByte_Unsigned planeNumber
);

/* End header wrapper*/
#endif

#endif /* NO_SUPPORT_PNG */
