/*
====================================================================
// MW_ProductHeaders.h:
//
// This defines the product header structures.
//
====================================================================
*/
#ifndef MW_PRODUCT_HEADERS_HEADER
#define MW_PRODUCT_HEADERS_HEADER

/*
====================================================================
// Required includes
====================================================================
*/
#include "MW_DataFieldTypes.h"

/* All structures here use byte alignment */
#pragma pack (push)
#pragma pack (1)


/*
====================================================================
// Compression types
====================================================================
*/

typedef enum
{
	None_MWCompressionType				= 0x00,
	DEFLATED_MWCompressionType			= 0x01,
	WeatherHuffman_MWCompressionType	= 0x02,
	WSI_RLE_MWCompressionType			= 0x03,
	WSI_RLE_DEFLATE_MWCompressionType	= 0x04,
	Downsampled_WSI_RLE_DEFLATE_MWCompressionType = 0x05


} TMW_CompressionType;

/*
====================================================================
// Header types
====================================================================
*/

typedef enum
{
	Generic_ProductHeaderType		= 0x00,
	GenericRaster_ProductHeaderType = 0x01,


} TMW_ProductHeaderType;

/*
====================================================================
// TMW_GenericProductHeader:
//
// This is the structure of the generic product header in the
// product stream.
====================================================================
*/

typedef struct
{
	// Value defined by TMW_ProductHeaderType enumeration
	TByte_Unsigned headerType;

	// Definitions found in TMW_ProductID (see MW_ProductIDs.h)
	TTwoByteInteger_Unsigned productID;

	// Time product issued
	TByte_Unsigned issueMonth; // 1-12
	TByte_Unsigned issueDayOfMonth; // 1-31
	TByte_Unsigned issueHour; // 0 -23
	TByte_Unsigned issueMinute; // 0-59

	// Time product begins to model world or record observations
	TByte_Unsigned validMonth; // 1-12
	TByte_Unsigned validDayOfMonth; // 1-31
	TByte_Unsigned validHour; // 0-23
	TByte_Unsigned validMinute; // 0-59

	// Georeference
	TTwoByteInteger_Signed maxLatitude; // -9000 to 9000 in 100ths of degrees
	TTwoByteInteger_Signed minLongitude; // -18000 to 18000 in 100ths of degrees
	TTwoByteInteger_Signed minLatitude; // -9000 to 9000 in 100ths of degrees
	TTwoByteInteger_Signed maxLongitude; // -18000 to 18000 in 100ths of degrees

} TMW_GenericProductHeader_Output;

/*
====================================================================
// TMW_GenericRasterHeader:
//
// This is the structure of the generic raster header in the
// product stream
====================================================================
*/

typedef struct
{
	// Value defined by TMW_ProductHeaderType enumeration
	TByte_Unsigned headerType;

	// Definitions found in TMW_ProductID (see MW_ProductIDs.h)
	TTwoByteInteger_Unsigned productID;

	// Time product issued
	TByte_Unsigned issueMonth; // 1-12
	TByte_Unsigned issueDayOfMonth; // 1-31
	TByte_Unsigned issueHour; // 0 -23
	TByte_Unsigned issueMinute; // 0-59

	// Time product begins to model world or record observations
	TByte_Unsigned validMonth; // 1-12
	TByte_Unsigned validDayOfMonth; // 1-31
	TByte_Unsigned validHour; // 0-23
	TByte_Unsigned validMinute; // 0-59

	// Georeference
	TTwoByteInteger_Signed maxLatitude; // -9000 to 9000 in 100ths of degrees
	TTwoByteInteger_Signed minLongitude; // -18000 to 18000 in 100ths of degrees
	TTwoByteInteger_Signed minLatitude; // -9000 to 9000 in 100ths of degrees
	TTwoByteInteger_Signed maxLongitude; // -18000 to 18000 in 100ths of degrees

	// Raster properties
	TTwoByteInteger_Unsigned numRows;
	TTwoByteInteger_Unsigned numColumns;

	TByte_Unsigned bitsPerPixel; // 0-8 bits per pixel, all products are currently 8bpp

	// The number of distinct rasters that occur one after another.
	// For example, radar has 2 planes: type and intensity
	TByte_Unsigned numPlanes;

	// This static part is followed by numPlanes resolution specifiers.
	// The precision and offset of each data point to its value.


} TMW_GenericRasterProductHeader_Output;

//--------------------------------------------------------------------

// The maximum number of planes that can be defined in a raster
#define MAX_PLANES_IN_RASTER 9

//--------------------------------------------------------------------

typedef struct
{
	TByte_Unsigned precisionSpecifier;
	TByte_Unsigned offsetSpecifier;

} TMW_GenericRasterProductHeader_FixedScaleSpecifier;


/*
#################################################################
// As input it occurs in bitfields
// ANSI C specifies that bitfield structure alignment and padding
// cannot be assumed. (Ignoring this is a common mistake made
// when tryingto comply with ANSI C.)
//
// Therefore a protocol header cannot use a bitfield structure.
// We have to use a custom bit field reading function and go by
// field lengths only.
//
// Note that the bitfield input headers are byte aligned on purpose.
//
//
// Generic product header, bitpacked , from MSB bit to LSB bit is:
//	HeaderType: 1
//	ProductID:	9
//	Issue
//		Month:	4
//		DayOfMonth:	5
//		Hour:	5
//		Minute: 6
//	Valid
//		Month:	4
//		DayOfMonth:	5
//		Hour:	5
//		Minute: 6
//	UpperLeft
//		maxLatitude:15
//		minLongitude:16
//	LowerRight
//		minLatitude:15
//		maxLongitude:16
//-------------------------
//	Total = 112 bits is 14 bytes
//
// Generic Raster Product Header adds to the end
//
//	NumBitsPerPixel: 3
//	NumPlanes:		 3

// And then NumPlanes instances of fixed scale specifiers,
// each consisting of ...
//	precision:		 8
//	offset:			 8

//
//
#################################################################
*/

#define GPH_HEADERTYPE_NUMBITS 1

#define GPH_PRODUCTID_NUMBITS 9

#define GPH_MONTH_NUMBITS 4
#define GPH_DAYOFMONTH_NUMBITS 5
#define GPH_HOUR_NUMBITS 5
#define GPH_MINUTE_NUMBITS 6

#define GPH_LATITUDE_NUMBITS 15
#define GPH_LONGITUDE_NUMBITS 16


#define GPRH_NUMROWS_NUMBITS 13
#define GPRH_NUMCOLUMNS_NUMBITS 13

#define GPRH_BITSPERPIXEL_NUMBITS 3
#define GPRH_NUMPLANES_NUMBITS	3

#define GPRH_PRECISION_NUMBITS 8
#define GPRH_OFFSET_NUMBITS 8

/*--------------------------------------------------------------------*/

/* Done byte alignment */
#pragma pack (pop)


/* End of header wrapper */
#endif

