/*
====================================================================
// MW_DataFieldTypes.h:
//
// Copyright � 2005 WSI Corporation.  All rights reserved.
// Author: Damon M. Hill
//
// This type defines some basic data structures which are aliases for
// the platform's representation of certain size integers.
//
====================================================================
*/

/* Header wrapper*/
#ifndef MW_DATAFIELDTYPES_INCLUDE
#define MW_DATAFIELDTYPES_INCLUDE

/*
################################################################################
# Native type definitions
################################################################################
*/

typedef long 			TFourByteInteger_Signed;
typedef unsigned long 	TFourByteInteger_Unsigned;
typedef short			TTwoByteInteger_Signed;
typedef unsigned short	TTwoByteInteger_Unsigned;
typedef signed char		TByte_Signed;
typedef unsigned char	TByte_Unsigned;

/* Native string char type */
typedef char		TChar;

/* ASCII string char type */
typedef char		TASCIIChar;

/* Callback function extra argument type */
typedef void*		TLParam;

/*
################################################################################
# NULL pointer value
################################################################################
*/
#ifndef NULL
	#define NULL 0
#endif

/*
################################################################################
# Return values for functions
################################################################################
*/

typedef enum
{
    MWRes_OperationFailed 	= 0x00,			/* The function failed due to unspecified failure of a platform method */
    MWRes_Success 			= 0x01,			/* The function was successful */
    MWRes_EndOfIteration	= 0x02,			/* There are no more objects to iterate */
    MWRes_NoMatchFound		= 0x03,			/* No match for the search/retrieval/removal was found in the structure */
	MWRes_EndOfDeflatedData = 0x04,			/* The end of the deflated data occured within this inflation request */
	MWRes_InputBufferExhausted = 0x05,		/* More input deflated data is required in order to continue the inflation */
    MWRes_BadCallingOrder 	= -0x01,		/* The calling order of the function was not followed */
    MWRes_BadParamValue		= -0x10,		/* A parameter value was not valid */
    MWRes_NullPointer		= -0x20,		/* An input parameter pointer was null */
    MWRes_StringTooLong		= -0x21,		/* A string parameter was too long for its intended storage */
	MWRes_DataStructureFull	= -0x22,		/* The data structure is already full and cannot hold any more */
	MWRes_InflationError 	= -0x23,		/* The data stream encountered an INFLATE error */
	MWRes_UnrecognizedHeaderType = -0x24,	/* The header type declared in the product is not a recognized value */
	MWRes_ProductNotExpectedSize = -0x25,	/* The product size was not that expected, or was not long enough to be valid */
	MWRes_UnrecognizedTransmogrificationType = -0x26, /* The type of compression transform to perform from input to output was not one in the code */
	MWRes_ProductContentsInvalid = -0x27,	/* Something in the product did not meet the content specification for that product */
	MWRes_CommunicationsError	 = -0x28,	/* An error on a communications pipe occured */
	MWRes_TransportProtocolError = -0x29,	/* An error in a transport protocol occured */
	MWRes_ProductHeaderFieldInvalid = -0x30, /* A product header field was out of its valid range */
	/* Fatal errors*/
    MWRes_OutOfMemory 		= -0x100,		/* Not enough memory to perform the operation (fatal) */
	MWRes_CodeFault			= -0x101		/* An error that can only arise from faulty code was detected. (fatal) */

} TMW_ResultCode;

/* End header wrapper */
#endif
