/*
====================================================================
// MW_BitFieldOperators.h:
//
// This module provides a set of functions for working with
// bit fields.
//
// Copyright � 2005 WSI Corporation.  All rights reserved.
// Author: Damon M. Hill
//
====================================================================
*/

#ifndef MW_BITFIELDOPERATORS_HEADER
#define MW_BITFIELDOPERATORS_HEADER


/*
====================================================================
// Required includes
====================================================================
*/

#include "MW_DataFieldTypes.h"

/*
//====================================================================
// signExtendBitField:
//
// This method sign extends a 2's complement bit field.
// Use it after calling readBitField if the bit field is signed.
//
// PARAMETERS:
//
//	p_fieldBytes:
//			The field bytes, as returned from readBytField
//
//	numBitsInField:
//			The number of bits in the field
//
//====================================================================
*/
TMW_ResultCode signExtendBitField
(
	TByte_Unsigned* p_fieldBytes,
	TFourByteInteger_Unsigned numBitsInField
);

/*
====================================================================
// readBitField:
//
// This method reads a field consisting of 1 or more bits
// into an array of bytes in HILO order, with LSB alignment
// per byte.
//
// PARAMETERS:
//
//	p_fieldStorage:
//		Pointer to the first byte in the array of bytes which will
//		hold the bit field in HILO order.
//
//	numBitsInField:
//		The number of bits in the field. This must be >= 1
//
//	numSourceBits:
//		The number of bits of input available for reading
//
//	p_sourceBits:
//		The array of bytes containing the bits for reading
//
//	inout_p_bitsConsumed:
//		A pointer to a counter which tracks how many bits
//		of input were alredy consumed before this call. It is
//		modified by this call to reflect any bits consumed
//		by this operation.
//
// RETURNS:
//
//	MWRes_Success
//		If the field was read.
//
//	MWRes_InputBufferExhausted:
//		If there were not enough input bits.
//
//	MWRes_BadParamValue
//		If numBitsInField < 1
//
====================================================================
*/

TMW_ResultCode readBitField
(
	TByte_Unsigned* p_fieldStorage,
	TFourByteInteger_Unsigned numBitsInField,
	TFourByteInteger_Unsigned numSourceBits,
	TByte_Unsigned* p_sourceBits,
	TFourByteInteger_Unsigned* inout_p_bitsConsumed
);


/* End header wrapper*/
#endif

