/******************************************************************************/
/*                Copyright (c) Sirius XM Satellite Radio, Inc.               */
/*                            All Rights Reserved                             */
/*      Licensed Materials - Property of Sirius XM Satellite Radio, Inc.      */
/******************************************************************************/
/*******************************************************************************
*
*$Workfile:      sxm_timers_incl.h $
*$Author(s):     Eugene Lopatukhin $
*$Creation Date: 10/5/2013 $
*
*DESCRIPTION
*
*	Private header file for timers service.
*
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef SXM_TIMERS_INCL_H
#define SXM_TIMERS_INCL_H

#include "sxm_typ.h"

#ifdef __cplusplus
extern "C" {
#endif

  /**************/
 /** INCLUDES **/
/**************/

  /***************/
 /** CONSTANTS **/
/***************/
#define INVALID_TIMER_HANDLE ((uint)-1)

  /**************/
 /** TYPEDEFS **/
/**************/

/** Defines timer types */
typedef enum {
    ONESHOT = 0, //!< One shot timer
    REARMING, //!< Periodical timer
    TIMER_TYPES_MAX
} SXMTimerType;

/** Defines timer's shot callback
 * \param[in] pArg callback argument
 */
typedef void (*SXMTimerCallback) (void *pArg);

/***************/
 /** VARIABLES **/
/***************/

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

SXESDK_INTERNAL_API int sxm_timers_stop(void);
SXESDK_INTERNAL_API BOOL sxm_timers_create_timer(uint timeInterval, uint *pTimerHandle,
                                                 SXMTimerType timerType,
                                                 SXMTimerCallback timerCallbackFunction,
                                                 void* timerCallbackArg);
SXESDK_INTERNAL_API BOOL sxm_timers_create_timer_ms(uint timeInterval, uint *pTimerHandle,
                                                    SXMTimerType timerType,
                                                    SXMTimerCallback timerCallbackFunction,
                                                    void* timerCallbackArg);
SXESDK_INTERNAL_API BOOL sxm_timers_delete_timer(uint timerHandle);
SXESDK_INTERNAL_API BOOL sxm_timers_start_timer(uint timerHandle);
SXESDK_INTERNAL_API BOOL sxm_timers_stop_timer(uint timerHandle);
SXESDK_INTERNAL_API BOOL sxm_timers_restart_timer(uint timerHandle);
SXESDK_INTERNAL_API BOOL sxm_timers_pause_timer(uint timerHandle);
SXESDK_INTERNAL_API BOOL sxm_timers_unpause_timer(uint timerHandle);
SXESDK_INTERNAL_API BOOL sxm_timers_is_active_timer(uint timerHandle);
SXESDK_INTERNAL_API BOOL sxm_timers_get_time(uint timerHandle, uint *pValue);
SXESDK_INTERNAL_API BOOL sxm_timers_set_new_interval(uint timerHandle, uint timeInterval, void *timerCallbackArg);
/**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#ifdef __cplusplus
}
#endif

#endif /* SXM_TIMERS_INCL_H */




