/******************************************************************************/
/*                Copyright (c) Sirius XM Satellite Radio, Inc.               */
/*                            All Rights Reserved                             */
/*      Licensed Materials - Property of Sirius XM Satellite Radio, Inc.      */
/******************************************************************************/
/***************************************************************************//**
 * 
 * \file sxm_iomanager_internal.h
 * \author Alexander Pylchagin
 * \date 8/8/2017
 * \brief I/O Manager Internal Interface
 *
 ******************************************************************************/

#ifndef SXM_IOMANAGER_INTERNAL_H_
#define SXM_IOMANAGER_INTERNAL_H_

#include <stdlib.h>
#include <sxm_common.h>
#include <sxm_iomanager.h>

#ifdef __cplusplus
extern "C" {
#endif

SXESDK_INTERNAL_API int sxm_iomanager_uninit(void);

SXESDK_INTERNAL_API int sxm_iomanager_reg(const SXMIOManagerRegInfo *pRegInfo);

SXESDK_INTERNAL_API int sxm_iomanager_unreg(const SXMIOManagerRegInfo *pRegInfo);

#ifdef __cplusplus
}
#endif

#endif /* SXM_IOMANAGER_H_ */
