/******************************************************************************/
/*                Copyright (c) Sirius XM Satellite Radio, Inc.               */
/*                            All Rights Reserved                             */
/*      Licensed Materials - Property of Sirius XM Satellite Radio, Inc.      */
/******************************************************************************/
/*****************************************************************************//**
 * \file sxm_image_internal.h
 * \author Alexander Pylchagin
 * \date 7/03/2017
 *
 * Header for the SXe Image API.
 ********************************************************************************/
#ifndef SXM_IMAGE_INTERNAL_H_
#define SXM_IMAGE_INTERNAL_H_

#include "sxm_image.h"

/** Defines unknown image size encouraging function to retrieve the size from
 * the file system
 */
#define SXM_IMAGE_UNKNOWN_SIZE ((size_t)-1)

SXESDK_INTERNAL_API int sxm_image_size(const SXMImage *img,
                                       size_t *size);
SXESDK_INTERNAL_API int sxm_image_init(SXMImage *img,
                                       char type,
                                       const char *module,
                                       const char *file,
                                       size_t size);
SXESDK_INTERNAL_API int sxm_image_save(const SXMImage *img,
                                       const void *pData);

#endif /* SXM_IMAGE_INTERNAL_H_ */