/******************************************************************************/
/*                Copyright (c) Sirius XM Satellite Radio, Inc.               */
/*                            All Rights Reserved                             */
/*      Licensed Materials - Property of Sirius XM Satellite Radio, Inc.      */
/******************************************************************************/
/***************************************************************************//**
*
* \file sxm_deflate.h
* \author Leslie French, Sergey Kotov
* \date 8/20/2013
*
* Header file for (G)ZIP deflate.
*
*******************************************************************************/

#ifndef SXM_DEFLATE_H
#define SXM_DEFLATE_H

#include <sxm_build.h>
#include <sxm_typ.h>
#include <util/sxm_bitbuff.h>

#ifdef __cplusplus
extern "C"
{
#endif

/** PKZIP file descriptor related to the internal PKZIP file data */
typedef struct
{
    /** Flag indicating that reported path is directory */
    BOOL isDirectory;
    /** Extracted file path */
    const char *pFileName;
    /** File size */
    size_t uncompressedSize;
    /** Internal data offset in the archive file */
    size_t fileOffset;
} SXMPKZipFileDesc;

/***************************************************************************//**
 *
 * File path notification callback to enumerate files in the archive.
 *
 * \param[in] pDesc pointer to \ref SXMPKZipFileDesc structure
 * \param[in] pUserData Pointer to the user data specified by the caller of
 *                      \ref sxm_deflate_pkzip_file or
 *                      \ref sxm_deflate_pkzip_enumerate
 *
 * \return SXe error code
 *
 ******************************************************************************/
typedef int(*SXM_PKZIP_CALLBACK)(const SXMPKZipFileDesc *pDesc,
                                 void *pUserData);

extern SXESDK_INTERNAL_API int sxm_deflate(SXMBitBuff *pkt,
                                           byte *out,
                                           size_t out_size);

extern SXESDK_INTERNAL_API int sxm_deflate_zipbuffer(SXMBitBuff *pkt,
                                                     byte *out,
                                                     size_t out_size);

extern SXESDK_INTERNAL_API int sxm_deflate_size(SXMBitBuff *pkt);

extern SXESDK_INTERNAL_API int sxm_deflate_zipfile(FILE *in, FILE *out);

extern SXESDK_INTERNAL_API int sxm_deflate_pkzip_file(FILE *pFile,
                                                      const char *pOutDir,
                                                      const char *pDetectExtension,
                                                      SXM_PKZIP_CALLBACK fileCallback,
                                                      void *pUserData);

extern SXESDK_INTERNAL_API int sxm_deflate_pkzip_enumerate(FILE *pFile,
                                                           SXM_PKZIP_CALLBACK fileCallback,
                                                           void *pUserData);

extern SXESDK_INTERNAL_API int sxm_deflate_pkzip_read(FILE *pFile,
                                                      size_t fileOffset,
                                                      void *pOutBuf,
                                                      size_t outBufSize);

extern SXESDK_INTERNAL_API int sxm_deflate_pkzip_alloc_and_read(FILE *pFile,
                                                                size_t fileOffset,
                                                                void **ppOut,
                                                                size_t *pDataSize);

extern SXESDK_INTERNAL_API int sxm_deflate_pkzip_copy(FILE *pFileSource,
                                                      size_t fileOffset,
                                                      FILE *pFileOut);

#ifdef __cplusplus
}
#endif

#endif /* #ifndef SXM_DEFLATE_H */
