/******************************************************************************/
/*                Copyright (c) Sirius XM Satellite Radio, Inc.               */
/*                            All Rights Reserved                             */
/*      Licensed Materials - Property of Sirius XM Satellite Radio, Inc.      */
/******************************************************************************/
/***************************************************************************//**
*
* \file sxm_callback_incl.h
* \author Eugene Lopatukhin
* \date 10/5/2013 $
*
* Private header file for callback service.
*
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef SXM_CALLBACK_INCL_H
#define SXM_CALLBACK_INCL_H

#include "sxm_typ.h"

#ifdef __cplusplus
extern "C" {
#endif

  /**************/
 /** INCLUDES **/
/**************/

  /***************/
 /** CONSTANTS **/
/***************/

  /**************/
 /** TYPEDEFS **/
/**************/

  /***************/
 /** VARIABLES **/
/***************/

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/
SXESDK_INTERNAL_API int sxm_callback_start(void);
SXESDK_INTERNAL_API int sxm_callback_stop(void);
SXESDK_INTERNAL_API int sxm_callback_req(void(*callback)(int, int), uint type, uint param);

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#ifdef __cplusplus
}
#endif

#endif /* SXM_CALLBACK_INCL_H */
