/************************************************************************
 *									*
 *            SMS_LLI_RFD							*
 *            =======							*
 *									*
 *                                 Copyright 2013 Sirius XM Radio, Inc. *
 *                                                 All Rights Reserved. *
 *               Licensed Materials - Property of Sirius XM Radio, Inc. *
 *									*
 *    Level of indirection to isolate usage of FILE from SMS includes.  The SDK RFD		*
 *    implementation uses the runtime c specification.  Not the OSAL version.  All RFD  *
 *    was moved for consistency.		*
 *									*
 ************************************************************************/

#include <sxm_build.h>

#if defined(SXM_USE_SMS)
#define DEBUG_VAR ((shell) ? shell->debug_level : -1)
#include <stdio.h>
#include <sxm_sdk.h>
#include <util/sxm_noname_internal.h>
#include <util/lli.h>
#include "sms_lli_internal.h"

//
//  RFD interface
//

int sxm_lli_rfd_init(ptr handle){
	return sxm_lli_core_rfd_init(sms_lli_internal_get_rfd(handle),
								 sms_lli_internal_get_ds(handle));
}

FILE *sxm_lli_rfd_open(ptr handle, SXMRfdMetadata* meta, int frag){
	return sxm_lli_core_rfd_open(sms_lli_internal_get_rfd(handle),
								 meta,
								 frag);
}

int sxm_lli_rfd_start(ptr handle, SXMRfdMetadata* meta){
	return sxm_lli_core_rfd_start(sms_lli_internal_get_rfd(handle),
							  	  sms_lli_internal_get_ds(handle),
							  	  meta);
}

int sxm_lli_rfd_status(ptr handle, int id, SXMRfdMetadata *meta){
	return sxm_lli_core_rfd_status(sms_lli_internal_get_rfd(handle),
							  	   id,
							  	   meta);
}

int sxm_lli_rfd_remove(ptr handle, int id){
	return sxm_lli_core_rfd_remove(sms_lli_internal_get_rfd(handle),
							  	   id);
}

int sxm_lli_rfd_add(ptr handle, byte* packet, int pl){
	return sxm_lli_core_rfd_add(sms_lli_internal_get_rfd(handle),
								packet,
								pl);
}

void sxm_lli_rfd_stop(ptr handle){
	sxm_lli_core_rfd_stop(sms_lli_internal_get_rfd(handle));
}

void sxm_lli_rfd_set_db_updated(ptr handle){
	sxm_lli_sms_rfd_set_db_updated(handle);
}

#endif
