/************************************************************************
 *                                                                      *
 *            SXM_NONAME.H                                              *
 *            ============                                              *
 *                                                                      *
 *                                 Copyright 2013 Sirius XM Radio, Inc. *
 *                                                 All Rights Reserved. *
 *               Licensed Materials - Property of Sirius XM Radio, Inc. *
 *                                                                      *
 *    These are helper macros designed to make the code more readable   *
 *    but not following the SXM naming conventions.                     *
 *                                                                      *
 ************************************************************************/

#ifndef SXM_NONAME_H
#define SXM_NONAME_H

#ifdef __cplusplus
extern "C" {
#endif

#define BSAREF(_table, _bsaindex) (((ushort)(_table)<<8) | (_bsaindex))
#define BSAREF_TABLE(_ref) ((_ref)>>8)
#define BSAREF_INDEX(_ref) ((_ref) & 0xff)

#ifdef SXM_DEBUG_PRODUCTION
#ifndef SXMLOGF
#define SXMLOGF(_v, _b, _s, _p, _f, ...)
#endif
#define SXMDUMP(_v, _b, _s, _p, _l) 
#else
#ifndef SXMLOGF
#define SXMLOGF(_v, _b, _s, _p, _f, ...) \
    if  ((_v) & ((_b) << (_s))) sxm_file_log(_p "%s" _f, __FUNCTION__, ##__VA_ARGS__)
#endif
#define SXMDUMP(_v, _b, _s, _p, _l) \
    if  ((_v) & ((_b) << (_s))) sxm_file_dump((byte *)_p, _l)
#endif

#ifndef DEBUG_VAR
#define DEBUG_VAR ((service) ? service->ds.debug_level : (uint)(-1))
#endif

#define CALLB_API(_f, ...) SXMLOGF(DEBUG_VAR, 1, 0, "[-> ", _f, ##__VA_ARGS__)
#define CALLR_API(_f, ...) SXMLOGF(DEBUG_VAR, 1, 0, "<-> ", _f, ##__VA_ARGS__)
#define ENTER_API(_f, ...) SXMLOGF(DEBUG_VAR, 1, 0, "->> ", _f, ##__VA_ARGS__)
#define LEAVE_API(_f, ...) SXMLOGF(DEBUG_VAR, 1, 0, "<<- ", _f, ##__VA_ARGS__)
#define TRACE_API(_f, ...) SXMLOGF(DEBUG_VAR, 2, 0, "--- ", _f, ##__VA_ARGS__)
#define DEBUG_API(_f, ...) SXMLOGF(DEBUG_VAR, 4, 0, "+++ ", _f, ##__VA_ARGS__)
#define DUMPB_API(_p, _l)  SXMDUMP(DEBUG_VAR, 8, 0, _p, _l)

#define CALLB_LLI(_f, ...) SXMLOGF(DEBUG_VAR, 1, 28, "[-> ", _f, ##__VA_ARGS__)
#define CALLR_LLI(_f, ...) SXMLOGF(DEBUG_VAR, 1, 28, "<-> ", _f, ##__VA_ARGS__)
#define ENTER_LLI(_f, ...) SXMLOGF(DEBUG_VAR, 1, 28, "->> ", _f, ##__VA_ARGS__)
#define LEAVE_LLI(_f, ...) SXMLOGF(DEBUG_VAR, 1, 28, "<<- ", _f, ##__VA_ARGS__)
#define TRACE_LLI(_f, ...) SXMLOGF(DEBUG_VAR, 2, 28, "--- ", _f, ##__VA_ARGS__)
#define DEBUG_LLI(_f, ...) SXMLOGF(DEBUG_VAR, 4, 28, "+++ ", _f, ##__VA_ARGS__)
#define DUMPB_LLI(_p, _l)  SXMDUMP(DEBUG_VAR, 8, 28, _p, _l)

#ifdef __cplusplus
}
#endif

#endif
