/************************************************************************
 *                                                                      *
 *            Build and Analyse the various SDK files                   *
 *            =======================================                   *
 *                                                                      *
 *  Copyright 2013 Sirius XM Radio, Inc.                                *
 *  All Rights Reserved.                                                *
 *  Licensed Materials - Property of Sirius XM Radio, Inc.              *
 *                                                                      *
 *    Header for SDK file tool                                          *
 *                                                                      *
 ************************************************************************/

#ifndef SDKFILES_H
#define SDKFILES_H

#include <sxm_common.h>
#include "sdkfiles_common.h"
#include <util/sxm_time_internal.h>

#ifndef SDKFILES_STANDALONE_BUILD
#include <sxm_sdk.h>
#include <util/sxm_common_internal.h>
#include <util/sxm_noname_internal.h>
#else
#include <util/sxm_memory_internal.h>
#include "sdk_tql.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifdef _WIN32
#include <windows.h>
#define snprintf _snprintf
#endif

#ifdef SDKFILES_STANDALONE_BUILD

/* Common definitions (from SXe headers) */
/* ===================================== */

#define SXM_DB_INVALID_ENTRY        (0xffffffff)

#define ARRAY_SIZE(_a) (sizeof(_a) / sizeof((_a)[0]))

#define BIT(_j)         (1U << (_j))
#define BITP(_a, _j)    ((_a)[(_j) >> 5] & BIT((_j) & 31))
#define BITS(_a, _j)    (_a)[(_j) >> 5] |= BIT((_j) & 31)
#define BITC(_a, _j)    (_a)[(_j) >> 5] &= ~BIT((_j) & 31)
#define BITSET(a,b)     ((a) |= (1U << (b)))
#define BITCLR(a,b)     ((a) &= (~(1U << (b))))
#define ISBITSET(a,b)   ((a) & ((1U << (b))))

/** Align a pointer to a uint type size boundary
 * \param[in] x the pointer to be aligned
 */
#define ALIGN_INT(x) ((byte *)((((size_t)(x) + sizeof(uint) - 1) / sizeof(uint)) * sizeof(uint)))

#ifndef MAX
#define MAX(_a, _b) ((_a) > (_b) ? (_a) : (_b))
#endif

#ifndef MIN
#define MIN(_a, _b) ((_a) < (_b) ? (_a) : (_b))
#endif

#ifndef IS_IN_RANGE
#define IS_IN_RANGE(i, min, max) (((i) >= (min)) && ((i) <= (max)))
#endif

#ifndef SXM_CRC32_POLYNOMIAL
#define SXM_CRC32_POLYNOMIAL        (0xEDB88320U)
#endif

#ifndef SXM_CRC32_INIT_VAL
#define SXM_CRC32_INIT_VAL          (0xFFFFFFFFU)
#endif

#ifndef STATIC_ASSERT
#define STATIC_ASSERT(_val, _msg) \
    typedef struct _msg##Assert{ int _msg: !!(_val); } _msg##_ASSERT;
#endif
#define TYPE_SIZE_STATIC_ASSERT(_t, _s) \
    STATIC_ASSERT(sizeof(_t) == (_s), _t##_must_be_##_s##_byte_len)
#define TYPE_SIZE_STATIC_LE_ASSERT(_t, _s) \
    STATIC_ASSERT(sizeof(_t) <= (_s), _t##_must_be_less_or_equal##_s##_byte_len)

#define MODUP(_val, _bit) ((((_val) + (1 << (_bit)) - 1) >> (_bit)) << (_bit))

/* Stubs */
/* ===== */

#ifndef fix2float
#define fix2float(_i)   ((float)(_i) / 32768.0f)
#endif

#ifndef float2fix
#define float2fix(_a)   ((int)((_a) * 32768))
#endif

#ifndef strequ
#define strequ(_a, _b)  (strcmp((_a), (_b)) == 0)
#endif

#ifndef sxe_malloc
#define sxe_malloc(_s) malloc(_s)
#endif

#ifndef sxe_calloc
#define sxe_calloc(_c, _s) calloc(_c, _s)
#endif

#ifndef sxe_free
#define sxe_free(_p) free(_p)
#endif

#ifndef MIN
#define MIN(_a, _b) ((_a) < (_b) ? (_a) : (_b))
#endif

#ifndef MAX
#define MAX(_a, _b) ((_a) > (_b) ? (_a) : (_b))
#endif

#ifndef sxm_crc32_calculate
#define sxm_crc32_calculate(_b, _len) doCRC((_b), (_len))
#endif

#ifndef sxm_crc32_part
#define sxm_crc32_part(_crc, _b, _len) doCRC_part((_crc), (_b), (_len))
#endif

#ifndef sxm_file_open
#define sxm_file_open(_t, _m, _f, _mode) sdkfiles_file_open((_t), (_m), (_f), (_mode))
#endif

#ifndef sxm_file_open_or_create
#define sxm_file_open_or_create(_t, _m, _f, _mode) sdkfiles_file_open_or_create((_t), (_m), (_f), (_mode))
#endif

#ifndef sxm_file_remove
#define sxm_file_remove(_t, _m, _f) sdkfiles_file_remove((_t), (_m), (_f))
#endif

#ifndef sxm_file_close
#define sxm_file_close(_f) sdkfiles_file_close((_f))
#endif

#ifndef sxm_time_now_utc
#define sxm_time_now_utc() (0)
#endif

#ifndef sxm_sxe_time_encode
#define sxm_sxe_time_encode(_v) (0)
#endif

#ifndef sxm_sxi_extract_time
#define sxm_sxi_extract_time(_v) sdkfiles_sxi_extract_time(_v)
#endif

#ifndef TF_LOG
#ifndef SXM_DEBUG_PRODUCTION
#define TF_LOG(_fmt, ...) {printf(_fmt, ##__VA_ARGS__); puts("");}
#else
#define TF_LOG(_fmt, ...)
#endif
#endif

#ifndef CF_LOG
#ifndef SXM_DEBUG_PRODUCTION
#define CF_LOG(_fmt, ...) {printf(_fmt, ##__VA_ARGS__); puts("");}
#else
#define CF_LOG(_fmt, ...)
#endif
#endif

/* Utilities */
/* ========= */

extern ushort sxm_crc16_calculate(const void *, uint);

#endif /* #ifdef SDKFILES_STANDALONE_BUILD */

#ifdef __cplusplus
}
#endif

#endif /* #ifndef SDKFILES_H */
