/************************************************************************
 *                                                                      *
 *            Build and Analyse the sports file                         *
 *            =================================                         *
 *                                                                      *
 *                                 Copyright 2013 Sirius XM Radio, Inc. *
 *                                                 All Rights Reserved. *
 *               Licensed Materials - Property of Sirius XM Radio, Inc. *
 *                                                                      *
 *    analyse sports cfile                                              *
 *                                                                      *
 ************************************************************************/

#include "sdkfiles.h"

 /** NB: TO BE SURE THAT ALL INTERNAL DATA STRUCTURES AND MACROSES ARE THE SAME **/
#define SDKFILES_BUILDER
#include <sports/sxm_sports_internal.h>
#undef SDKFILES_BUILDER

void sports_check_cfile(void) {
    uint i, j;
    ushort ix;
    byte *aus;
    SportSection *ss;
    AffiliationSection *as;
    STableSection *ts;
    int rc;

    rc = cfile_open(SPORTS_SERVICE_NAME, SPORTS_CFILE_NAME, SPORTS_SERVICE_NAME);
    if (SXM_E_OK != rc)
    {
        return;
    }

    printf("Schema version %u\n", cfile_schema());
    if (cfile_schema() != SPORTS_CFILE_SCHEMA_VERSION)
    {
        cfile_close();
        fatal("Unsupported schema version %u\n", cfile_schema());
        return;
    }

    printf("\nSport Definitions\n=================\n");
    fflush(stdout);
    aus = cfile_load(0);
    ss = (SportSection *)(void*)aus;
    printf(" Id  Ix             Sport       Tables\n");

    for (i = 0; i < 256; i++) {
        ix = ss->map[i];
        if (ix < 32) {
            printf(" %2d: %2u %20s   ", i, ix, ss->sport[ix].name);
            for (j = 0; (j < ss->sport[ix].tno) && (j < 16); j++)
                printf("%2d ", ss->sport[ix].tables[j]);
            printf("\n");
        }
    }

    sxe_free(aus);

    printf("\nAffiliations\n==========\n");
    aus = cfile_load(1);
    as = (AffiliationSection *)(void*)aus;

    printf("   Id    Ix   GMI AFID SPID Ver Parent Level Root  Name\n");
    for (i = 0; i < 1024; i++) {
        ix = as->map[i];
        if (ix < 256) {
            printf(" %4d: %4u %5d %4d %4d %3d %6d %5d %4d  %s\n", i, ix, 
                as->aff[ix].global, as->aff[ix].afid, as->aff[ix].spid,
                as->aff[ix].ver, as->aff[ix].parentid, as->aff[ix].level, as->aff[ix].rootid,
                as->aff[ix].name);
        }
    }
    printf("\nSaved Tables\n============\n");

    for (i = 0; i < 256; i++) {
        if (as->aff[i].name[0]) {
            printf("    %s\n", as->aff[i].name);
            for (j = 0; j < 17; j++) {
                Table *t = &as->aff[i].schedule[j];
                if  (t->tabno != 0xffff)
                    printf("        S[%2d]: %2d %4d %4d %6d %d %d %8d %08x %d\n", j,
                    t->tabno, t->heapix, t->size, t->epoch, t->season, t->offset, t->timeStamp, t->crc, t->inuse);
            }
            for (j = 0; j < 24; j++) {
                Table *t = &as->aff[i].others[j];
                if  (t->tabno != 0xffff) {
                    printf("        O[%2d]: %2d %4d %4d %6d %d %d %8d %08x %d\n", j,
                        t->tabno, t->heapix, t->size, t->epoch, t->season, t->offset, t->timeStamp, t->crc, t->inuse);
                }
            }
        }
    }
    sxe_free(aus);

    printf("\nTables\n======\n");
    aus = cfile_load(2);
    ts = (STableSection *)(void*)aus;
    for (i = 0; i < 1024; i++) {
        ix = ts->map[i];
        if (ix < 64) {
            STable *t = &ts->table[ix];

            printf("%3d: %3u  Type %d Version %d\n", i, ix, t->tclass, t->ver);
            for  (j = 0; (j < t->lc) && (j < 64); j++) {
                printf("    %2d:  %2d %d %2d %d %d %6d %s\n", j,
                    t->l[j].lbid, t->l[j].dtype, t->l[j].lbtype,
                    t->l[j].dmod, t->l[j].prio, t->l[j].lbsize, t->l[j].text);    
            }
        }
    }
    sxe_free(aus);

    cfile_close();
}
