/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _STI_FRAMEWORK_H_
#define _STI_FRAMEWORK_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "sti_api.h"
#include "sti_protocol.h"

  /***************/
 /** CONSTANTS **/
/***************/

  /**************/
 /** TYPEDEFS **/
/**************/

/*
    This is the global STI-Framework Structure.
    Only one instance of this structure should exist.
*/

typedef struct sti_framework_struct
{
    // A linked list mutex to protect the list of installed protocols.
    OSAL_OBJECT_HDL hProtocolListMutex;

    // A linked list of installed protocols that use the STI-Framework.
    OSAL_OBJECT_HDL hProtocols;

} STI_FRAMEWORK_STRUCT;

/*
    This structure represents an STI Connection to a Protocol and
    it's associated Device I/O interface. One of these structures exist
    for each and every connection made via the STI.

*/

typedef struct sti_connection_entry_struct
{
    // Entry handle (for direct remove)
    OSAL_LINKED_LIST_ENTRY hEntry;

    // Protocol entry this connection uses
    STI_PROTOCOL_ENTRY_STRUCT *psProtocolEntry;

    // Callback function and argument for this connection
    STI_PROTOCOL_CALLBACK vCallback;
    void *pvCallbackArg;

    // Connection name
    char acName[OSAL_MAX_OBJECT_NAME_LENGTH_WITH_NULL];

    // Connection specific argument (data)
    void *pvConnectionArgument;

    // Protocol specific connection data
    void *pvProtocolConnectionData;

    // A callback structure to populate as needed
    STI_PROTOCOL_CALLBACK_MSG_STRUCT sCallback;

} STI_CONNECTION_ENTRY_STRUCT; // STI_HDL

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

static N16 n16CompareProtocolDevices( void *pvArg1, void *pvArg2 );

static void vProtocolRelease (
    STI_PROTOCOL_ENTRY_STRUCT *psProtocolEntry
        );

static void vConnectionRelease (
    STI_CONNECTION_ENTRY_STRUCT *psConnectionEntry
        );

static N16 n16CompareCnxn( void *pvArg1, void *pvArg2);

static void *pvGetProtocolConnectionData ( STI_CONNECTION_ENTRY_STRUCT const *psConnection );

static BOOLEAN bAddProtocol (
    STI_PROTOCOL_ENTRY_STRUCT **ppsProtocolEntry,
    STI_PROTOCOL_CALLBACK vCallback,
    void *pvCallbackArg
        );

static STI_CONNECTION_ENTRY_STRUCT *psFindConnection(
    STI_PROTOCOL_HDL hProtocol,
    void *pvProtocolConnectionData,
    void **ppvData
        );

  /***************/
 /** VARIABLES **/
/***************/

STI_FRAMEWORK_STRUCT gsFramework = {
    OSAL_INVALID_OBJECT_HDL,
    OSAL_INVALID_OBJECT_HDL
        };

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _STI_FRAMEWORK_H_
