/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 *  This header file contains the external SXi LL Interface for STI.
 *  The SXI Implementation contained in this module implements what is
 *  described in RX000224 - SXi UART Link Layer
 *
 ******************************************************************************/

#ifndef SXILL_H_
#define SXILL_H_

#include "sti_api.h"
#include "sxiapi.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

// Rx Frame buffer services ALL connections to a single device
// Choose a block size of one fourth of a max frame
#define SXILL_RX_FRAME_BLOCK_SIZE (GtSxillRxFrameBlockSize)

// Macro to calculate how many blocks
// are needed to service a particular pool size
#define SXILL_NUM_BLOCKS_FOR_SIZE(size)        \
    (((size) / SXILL_RX_FRAME_BLOCK_SIZE) + 1)

// SXiLL Payload Types defined
#define SXILL_PAYLOAD_TYPE_LINK     (0)
#define SXILL_PAYLOAD_TYPE_CONTROL  (1)
#define SXILL_PAYLOAD_TYPE_DATA     (2)
#define SXILL_PAYLOAD_TYPE_AUDIO    (3)
#define SXILL_PAYLOAD_TYPE_DEBUG    (31)
#define SXILL_PAYLOAD_TYPE_UNKNOWN  (255)

/*********************/
/** GLOBAL TYPEDEFS **/
/*********************/

// The SXI-LL type is used to indicate message
// types and connections.
typedef UN8 SXILL_PAYLOAD_TYPE;

typedef enum sxill_rx_error_enum
{
    SXILL_RX_ERROR_NO_RX,
    SXILL_RX_ERROR_DEVICE

} SXILL_RX_ERROR_ENUM;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

// Size of an Rx Block (see _sxill.h)
extern const size_t GtSxillRxFrameBlockSize;

// SXILL-UART Protocol Interface (see sti_protocol.h)
extern const STI_PROTOCOL_INTERFACE GsSXILL;

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

BOOLEAN SXILL_bTxPayload (
    STI_PROTOCOL_HDL hProtocol,
    SXILL_PAYLOAD_TYPE tPayloadType,
    OSAL_BUFFER_HDL hPayload
        );

void SXILL_vHandleTx(
    STI_PROTOCOL_HDL hProtocol,
    STI_PROTOCOL_TX_PAYLOAD_STRUCT *psTx
        );

#endif /* SXILL_H */

