/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/

#ifndef STI_FRAMEWORK_H_
#define STI_FRAMEWORK_H_

#include "standard.h"
#include "osal.h"

#include "sti_api.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

/*
    An STI Protocol Entry
*/

typedef struct sti_protocol_entry_struct
{
    // Entry handle (for direct remove)
    OSAL_LINKED_LIST_ENTRY hEntry;

    // The device this protocol is associated with.
    // Only one protocol (link-layer) can run on the same
    // device.
    void *pvDevice;

    // Protocol interface
    const STI_PROTOCOL_INTERFACE *psProtocolIntf;

    // Protocol handle
    STI_PROTOCOL_HDL hProtocol;

    // Protocol connection list
    OSAL_OBJECT_HDL hConnectionListMutex;
    OSAL_OBJECT_HDL hConnectionList;

} STI_PROTOCOL_ENTRY_STRUCT;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

BOOLEAN STI_bInit( void );

void STI_vUninit( void );

OSAL_BUFFER_HDL STI_hAllocatePayload ( STI_HDL hSTI );

BOOLEAN STI_bFreePayload ( OSAL_BUFFER_HDL hPayload );

STI_PROTOCOL_RESULT_CODE_ENUM STI_eSendPayload (
    STI_HDL hSTI,
    BOOLEAN bBlock,
    OSAL_BUFFER_HDL hPayload,
    UN8 un8Retries,
    N32 n32Timeout
        );

BOOLEAN STI_bReceivePayload (
    STI_PROTOCOL_HDL hProtocol,
    void *pvProtocolConnectionData,
    STI_PROTOCOL_RX_PAYLOAD_STRUCT *psRx
        );

BOOLEAN STI_bTransmitPayload (
    STI_HDL hSTI,
    STI_PROTOCOL_TX_PAYLOAD_STRUCT *psTx
        );

BOOLEAN STI_bSendTimeout (
    STI_HDL hSTI
        );

BOOLEAN STI_bReceiveOOB (
    STI_PROTOCOL_HDL hProtocol,
    void *pvProtocolConnectionData,
    STI_OOB_TYPE_ENUM eOOBType,
    void *pvData
        );

BOOLEAN STI_bReceiveTimeout (
    STI_HDL hSTI
        );

void *STI_pvGetConnectionArgument ( STI_HDL hSTI );

#endif /* STI_FRAMEWORK_H_ */
