/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object: WS_ALERTS_LOCATION header file.
 *
 ******************************************************************************/

#ifndef WS_ALERTS_LOCATION_OBJ_H_
#define WS_ALERTS_LOCATION_OBJ_H_


#include "sms_api.h"
#include "ws_alerts_db_constants.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/


  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/


  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

WS_ALERTS_LOCATION_OBJECT WS_ALERTS_LOCATION_hCreate(
    SMS_OBJECT hParent,
    WS_ALERTS_LOCATIONS_ROW_STRUCT *psAlertLocationRow
        );

LOC_ID WS_ALERTS_LOCATION_tLocId(
    WS_ALERTS_LOCATION_OBJECT hWsAlertsLocation
        );

BOOLEAN WS_ALERTS_LOCATION_bIsPolygon(
    WS_ALERTS_LOCATION_OBJECT hWsAlertsLocation,
    BOOLEAN *pbResult
        );

WS_ALERT_MSG_ID WS_ALERTS_LOCATION_tMsgId(
    WS_ALERTS_LOCATION_OBJECT hWSAlertsLoc
        );

void WS_ALERTS_LOCATION_vDestroy (
    WS_ALERTS_LOCATION_OBJECT hWSAlertsLoc
        );

WS_ALERTS_LOCATION_OBJECT WS_ALERTS_LOCATION_hCreateDummy(
    SMS_OBJECT hParent
        );

void WS_ALERTS_LOCATION_vSetDummyId(
    WS_ALERTS_LOCATION_OBJECT hWSAlertsLoc,
    LOC_ID tLocId
        );

#endif /* WS_ALERTS_LOCATION_OBJ_H_ */
